                TITLE Mandel
                PAGE 66,132
     ; Fr TASM ab  V.3.0
.Model large, Pascal
.CODE
             PUBLIC ITERASM87  ; Iteration FPU,  87-Mode
             PUBLIC ITERASM487 ; Iteration FPU, 487-Mode
             PUBLIC ITERASM487b; Iteration FPU, 487-Mode, CPU/FPU-Interl
             PUBLIC ITERASMK3D ; Iteration; Single Precision 3Dnow! { as published }
             PUBLIC ITERASMK3DJ; Iteration; Single Precision 3Dnow! { better optimized }


             Locals @@

;  STACK-Layout:
            RET_ANZ  EQU 12          ; 16 Bytes auf STACK
IS          EQU     DWORD PTR [BP+12]; Single Prec
RS          EQU     DWORD PTR [BP+8]; Single Prec
GRENZE      EQU     WORD PTR  [BP+6];
TIEFE       EQU     WORD PTR  [BP+4]; globale Variable
RET_ADR     EQU     BP+2            ;-------------
BP_SAVE     EQU     BP+0            ; Save-Bereich
A           EQU     BP-2            ; lokale Variable
B           EQU     BP-4            ;



;---------------
iterasm87   PROC    NEAR            ;
            PUSH    BP              ; Erhalte BP
            MOV     BP,SP           ; Adressiere den Stack
            SUB     SP,4            ; Platz fuer 2 Integer
;
;  Verwendung der Register:
;  AX = Funktionswert: Iterationen
;  BX = +Grenze
;  DX = -Grenze
;  CX = Tiefe
;  SS:BP-> Stack  der CPU
;
            FINIT                          ; alles neu
            FLD    RS                      ; R laden
            FLD    IS                      ; L laden
            FLDZ                           ; A = 0
            FLDZ                           ; B = 0
            MOV     CX,TIEFE               ; CX = max Loopcount
            MOV     BX,GRENZE              ; BX = +GRENZE
            MOV     DX,BX
            NEG     DX                     ; DX = -GRENZE
            SUB     AX,AX                  ; AX = Funktionswert = 0
;
;   Quadriere (A + jB)**2 = A**2 - B**2 + j 2*A*B
;
@@ITER_2:   FLD     ST(1)           ; Kopiere A
            FMUL    ST(0),ST(0)     ; A**2

            FLD     ST(1)           ; Kopiere B
            FMUL    ST(0),ST(0)     ; B**2
            FSUB                    ; A**2 - B**2
;
            FADD    ST(0),ST(4)     ; A(n+1)=A**2 - B**2 + U
            FIST    WORD PTR [A]    ; Lege ab fuer Vergleich
            INC     AX              ; Funktionswert +1
;
            FXCH    ST(2)
            FMUL                    ; A*B
            FADD    ST(0),ST(0)     ; 2*A*B
            FADD    ST(0),ST(2)     ; B(n+1) = 2*A*B + V
            FIST    WORD PTR [B]    ; Lege ab fuer Vergleich
;
;  Sieh nach, ob A oder B > GRENZE ist
;
            CMP     [A],BX          ; A > +Grenze?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [A],DX          ; A < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            FWAIT                   ; Warte auf Ablage von B
            CMP     [B],BX          ; B > +Grenze ?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [B],DX          ; B < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            LOOP    @@ITER_2          ; A, B innerhalb +-Grenze
@@ITER_4:   FINIT
            MOV     SP,BP           ; Restore SP
            POP     BP              ;  und BP
            RET     RET_ANZ         ; Entferne Parameter
                ;---------------
iterasm87  ENDP

;  Same Procedure with .486p

.486p
;---------------
iterasm487 PROC    NEAR            ;
            PUSH    BP              ; Erhalte BP
            MOV     BP,SP           ; Adressiere den Stack
            SUB     SP,4            ; Platz fuer 2 Integer
;
;  Verwendung der Register:
;  AX = Funktionswert: Iterationen
;  BX = +Grenze
;  DX = -Grenze
;  CX = Tiefe
;  SS:BP-> Stack  der CPU
;
            FINIT                          ; alles neu
            FLD    RS                      ; R laden
            FLD    IS                      ; L laden
            FLDZ                           ; A = 0
            FLDZ                           ; B = 0
            MOV     CX,TIEFE               ; CX = max Loopcount
            MOV     BX,GRENZE              ; BX = +GRENZE
            MOV     DX,BX
            NEG     DX                     ; DX = -GRENZE
            SUB     AX,AX                  ; AX = Funktionswert = 0
;
;   Quadriere (A + jB)**2 = A**2 - B**2 + j 2*A*B
;
@@ITER_2:   FLD     ST(1)           ; Kopiere A
            FMUL    ST(0),ST(0)     ; A**2

            FLD     ST(1)           ; Kopiere B
            FMUL    ST(0),ST(0)     ; B**2
            FSUB                    ; A**2 - B**2
;
            FADD    ST(0),ST(4)     ; A(n+1)=A**2 - B**2 + U
            FIST    WORD PTR [A]    ; Lege ab fuer Vergleich
            INC     AX              ; Funktionswert +1
;
            FXCH    ST(2)
            FMUL                    ; A*B
            FADD    ST(0),ST(0)     ; 2*A*B
            FADD    ST(0),ST(2)     ; B(n+1) = 2*A*B + V
            FIST    WORD PTR [B]    ; Lege ab fuer Vergleich
;
;  Sieh nach, ob A oder B > GRENZE ist
;
            CMP     [A],BX          ; A > +Grenze?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [A],DX          ; A < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            CMP     [B],BX          ; B > +Grenze ?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [B],DX          ; B < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            LOOP    @@ITER_2          ; A, B innerhalb +-Grenze
@@ITER_4:   FINIT
            MOV     SP,BP           ; Restore SP
            POP     BP              ;  und BP
            RET     RET_ANZ
iterasm487 ENDP


.486p   ; wie zuvor aber CPU und  FPU verschrnkt
;---------------
iterasm487b PROC    NEAR            ;
            PUSH    BP              ; Erhalte BP
            MOV     BP,SP           ; Adressiere den Stack
            SUB     SP,4            ; Platz fuer 2 Integer
;
;  Verwendung der Register:
;  AX = Funktionswert: Iterationen
;  BX = +Grenze
;  DX = -Grenze
;  CX = Tiefe
;  SS:BP-> Stack  der CPU
;
            FINIT                          ; alles neu
            FLD    RS                      ; R laden
            FLD    IS                      ; L laden
            FLDZ                           ; A = 0
            FLDZ                           ; B = 0
            MOV     CX,TIEFE               ; CX = max Loopcount
            MOV     BX,GRENZE              ; BX = +GRENZE
            MOV     DX,BX
            NEG     DX                     ; DX = -GRENZE
            SUB     AX,AX                  ; AX = Funktionswert = 0
;
;   Quadriere (A + jB)**2 = A**2 - B**2 + j 2*A*B
;
@@ITER_2:   FLD     ST(1)           ; Kopiere A
            FMUL    ST(0),ST(0)     ; A**2

            FLD     ST(1)           ; Kopiere B
            FMUL    ST(0),ST(0)     ; B**2
            FSUB                    ; A**2 - B**2
;
            FADD    ST(0),ST(4)     ; A(n+1)=A**2 - B**2 + U
            FIST    WORD PTR [A]    ; Lege ab fuer Vergleich
            INC     AX              ; Funktionswert +1
;
            CMP     [A],BX          ; A > +Grenze?
            JG      @@ITER_4          ;  Ja, fertig

            FXCH    ST(2)

            CMP     [A],DX          ; A < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig

            FMUL                    ; A*B
            FADD    ST(0),ST(0)     ; 2*A*B
            FADD    ST(0),ST(2)     ; B(n+1) = 2*A*B + V
            FIST    WORD PTR [B]    ; Lege ab fuer Vergleich
;
;  Sieh nach, ob A oder B > GRENZE ist
;
            CMP     [B],BX          ; B > +Grenze ?
            JG      @@ITER_4          ;  Ja, fertig
            CMP     [B],DX          ; B < -Grenze ?
            JL      @@ITER_4          ;  Ja, fertig
            LOOP    @@ITER_2          ; A, B innerhalb +-Grenze
@@ITER_4:   FINIT
            MOV     SP,BP           ; Restore SP
            POP     BP              ;  und BP
            RET     RET_ANZ
iterasm487b ENDP


app_16Bit equ 1
include  ctmmxn.inc
;---------------
iterasmK3D  PROC    NEAR            ;
            PUSH    BP              ; Erhalte BP
            MOV     BP,SP           ; Adressiere den Stack
            SUB     SP,32           ; Platz fuer 4 Dwords
;
;  Verwendung der Register:
;  AX = Funktionswert: Iterationen
;  BX = +Grenze
;  DX = -Grenze
;  CX = Tiefe
;  SS:BP-> Stack  der CPU

          mEB EQU [BP-4]
          mEA EQU [BP-8]
          iB  EQU [BP-12]
          iA  EQU [BP-16]
          NULL2 EQU [BP-20]
          NULL  EQU [BP-24]
          EINSM EQU [BP-28]
          EINS  EQU [BP-32]

            XOR     EAX,EAX
            MOV     NULL,EAX
            MOV     NULL2,EAX
            MOV     EAX,03F800000h   ;=1
            MOV     EINS,EAX
            MOV     EAX,0BF800000h   ;=-1
            MOV     EINSM,EAX
            FEMMS                   ; alles neu
            MOVQ    MM0,Null        ; A = 0 | B=0
            MOVQ    MM1,Eins        ; 1     | -1
            MOVQ    MM2,RS          ; R+L laden
            MOV     CX,TIEFE        ; CX = max Loopcount
            MOV     BX,GRENZE      ; BX = +GRENZE
            MOV     DX,BX
            NEG     DX             ; DX = -GRENZE
            SUB     AX,AX           ; AX = Funktionswert = 0
;
;   Quadriere (A + jB)**2 = A**2 - B**2 + j 2*A*B
;   Entry   MM0                     ;A           | B
;           MM1                     ;1           | -1
;           MM2                     ;R           | I
;
@@ITER_2: ;  MOVQ    meA,MM0         ;meA=A       | B
          ;  MOVQ    MM3,MM0         ;MM3= A      | B
          ;  MOV     esi,meA         ;esi=A
          ;  XCHG    meB,esi         ;meA=A       | meB=A
          ;  MOV     meA,esi         ;meA=B       | meB=A
          ;  PFMUL   MM3,meA         ;MM3= A*B    | A*B


            MOVQ    MM3,MM0         ;MM3=A     | B
            MOVQ    MM4,MM0         ; oh weh
            PSLLQ   MM3,32          ; das Vertauschen ist
            PSRLQ   MM4,32          ; sehr mhsam ...
            POR     MM3,MM4         ;MM3=B      | A

            PFMUL   MM3,MM0         ;MM3= A*B    | A*B
            PFMUL   MM0,MM0         ;MM0= A**2   | B**2
            PFMUL   MM0,MM1         ;MM0= A**2   | -B**2
            PFACC   MM0,MM3         ;MM0= A**2 - B**2     | A*B+A*B
            PFADD   MM0,MM2         ;MM0= A**2 - B**2 + R | 2*A*B+I
                                    ;c:\ = A(n+1)              = B(n+1)
            PF2ID   MM4,MM0         ;iA = INT(A)  | iB = Int(B)
            MOVQ    iA,MM4
;  Sieh nach, ob A oder B > GRENZE ist
            INC     AX
            CMP     [iA],BX         ; A > +Grenze?
            JG      @@ITER_4        ;  Ja, fertig
            CMP     [iA],DX         ; A < -Grenze ?
            JL      @@ITER_4        ;  Ja, fertig
            CMP     [iB],BX         ; B > +Grenze ?
            JG      @@ITER_4        ;  Ja, fertig
            CMP     [iB],DX         ; B < -Grenze ?
            JL      @@ITER_4        ;  Ja, fertig
            LOOP    @@ITER_2        ; A, B innerhalb +-Grenze
@@ITER_4:   FEMMS
            MOV     SP,BP           ; Restore SP
            POP     BP              ;  und BP
            RET     RET_ANZ         ; Entferne Parameter
                ;---------------
iterasmK3D  ENDP

iterasmK3DJ PROC    NEAR            ;
            PUSH    BP              ; Erhalte BP
            MOV     BP,SP           ; Adressiere den Stack
            SUB     SP,32           ; Platz fuer 4 Dwords
;
;  Verwendung der Register:
;  AX = Funktionswert: Iterationen
;  BX = +Grenze
;  DX = -Grenze
;  CX = Tiefe
;  SS:BP-> Stack  der CPU

          mEB EQU [BP-4]
          mEA EQU [BP-8]
          iB  EQU [BP-12]
          iA  EQU [BP-16]
          NULL2 EQU [BP-20]
          NULL  EQU [BP-24]
          EINSM EQU [BP-28]
          EINS  EQU [BP-32]

            XOR     EAX,EAX
            MOV     NULL,EAX
            MOV     NULL2,EAX
            MOV     EAX,0h          ;XOr-Maske +1
            MOV     EINS,EAX
            MOV     EAX,80000000h   ;XOr-Maske -1
            MOV     EINSM,EAX
            FEMMS                   ; alles neu
            MOVQ    MM0,Null        ; A = 0 | B=0
            MOVQ    MM1,Eins        ; 1     | -1
            MOVQ    MM2,RS          ; R+L laden
            MOV     CX,TIEFE        ; CX = max Loopcount
            MOV     BX,GRENZE      ; BX = +GRENZE
            MOV     DX,BX
            NEG     DX             ; DX = -GRENZE
            SUB     AX,AX           ; AX = Funktionswert = 0
;
;   Quadriere (A + jB)**2 = A**2 - B**2 + j 2*A*B
;   Entry   MM0                     ;A           | B
;           MM1                     ;1           | -1
;           MM2                     ;R           | I
;
@@ITER_2:

            MOVQ       MM3, MM0   ; MM3=  A      | B
            PUNPCKHDQ  MM3, MM3   ; MM3=  A      | A
            PUNPCKLDQ  MM3, MM0   ; MM3=  B      | A

            PFMUL   MM3,MM0         ;MM3= A*B    | A*B
            PFMUL   MM0,MM0         ;MM0= A**2   | B**2
            PXOR    MM0,MM1         ;MM0= A**2   | -B**2
            PFACC   MM0,MM3         ;MM0= A**2 - B**2     | A*B+A*B
            PFADD   MM0,MM2         ;MM0= A**2 - B**2 + R | 2*A*B+I
                                    ;c:\ = A(n+1)              = B(n+1)
            PF2ID   MM4,MM0         ;iA = INT(A)  | iB = Int(B)
            MOVQ    iA,MM4
;  Sieh nach, ob A oder B > GRENZE ist
            INC     AX
            CMP     [iA],BX         ; A > +Grenze?
            JG      @@ITER_4        ;  Ja, fertig
            CMP     [iA],DX         ; A < -Grenze ?
            JL      @@ITER_4        ;  Ja, fertig
            CMP     [iB],BX         ; B > +Grenze ?
            JG      @@ITER_4        ;  Ja, fertig
            CMP     [iB],DX         ; B < -Grenze ?
            JL      @@ITER_4        ;  Ja, fertig
            LOOP    @@ITER_2        ; A, B innerhalb +-Grenze
@@ITER_4:   FEMMS
            MOV     SP,BP           ; Restore SP
            POP     BP              ;  und BP
            RET     RET_ANZ         ; Entferne Parameter
                ;---------------
iterasmK3DJ ENDP



            END
