unit TimerTestU;  // 22-OCT-98 as (Arne Schpers)
// Pseudo-Benchmark fr TDXTimer. Anzahl der Timer ist
// ber die obere Bildlaufleiste, Intervalle ber die
// untere Bildlaufleiste einstellbar. Ausnahmsweise weit-
// gehend kommentarfreie Zone, weil letztlich trivial

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, MMSystem, StdCtrls, ExtCtrls, DXTimer;

type
  TDXTTestForm = class(TForm)
    barTimerCount: TScrollBar;
    BarTimerInterval: TScrollBar;
    lTimerCount: TLabel;
    lRealEvtCount: TLabel; // tatschlich gezhlte Events/msec
    lEstEvtCount: TLabel;  // rechnerisch erwartete Events/msec
    Timer1: TTimer;  // ordinrer Windows-Timer frs Update
    lInterval: TLabel;  // von lRealEvtCount
    cAsync: TCheckBox;  // Umschaltung sync/async
    procedure barTimerCountChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BarTimerIntervalChange(Sender: TObject);
    procedure cAsyncClick(Sender: TObject);
  private
   procedure OnDXTimers(Sender: TObject);
  public
    StartTime, TimerCount: Integer;
    TimerList: TList;  // Items = TDXTimer
  end;

var DXTTestForm: TDXTTestForm;

implementation
{$R *.DFM}
procedure TDXTTestForm.barTimerCountChange(Sender: TObject);
var NewCount: Integer; NewTimer: TDXTimer;
begin
  NewCount := BarTimerCount.Position;
  while TimerList.Count > NewCount do
    with TimerList do
    begin
      TDXTimer(Items[Count-1]).Free;
      Delete(Count-1);
    end;
  while TimerList.Count < NewCount do
  begin
    NewTimer := TDXTimer.Create(Self);
    TimerList.Add(NewTimer);
    if cAsync.Checked
      then NewTimer.OnAsyncTimer := OnDXTimers
      else NewTimer.OnTimer := OnDXTimers;
    NewTimer.Interval := barTimerInterval.Position;
  end;
  Starttime := timeGetTime-1; TimerCount := 0;
  lTimerCount.Caption := 'Timers: '+IntToStr(NewCount);
  lEstEvtCount.Caption := 'Estimated Eventcount: '
       +IntToStr(NewCount*1000 div barTimerInterval.Position);
end;

procedure TDXTTestForm.FormCreate(Sender: TObject);
begin
  TimerList := TList.Create; BarTimerCountChange(Self);
  BarTimerInterval.Position := 10;
end;

procedure TDXTTestForm.FormDestroy(Sender: TObject);
begin
  TimerList.Free;
end;

procedure TDXTTestForm.OnDXTimers(Sender: TObject);
begin
  Inc(Timercount);
end;

procedure TDXTTestForm.Timer1Timer(Sender: TObject);
begin
  if TimerList.Count = 0 then lRealEvtCount.Caption := '--'
    else lRealEvtCount.Caption := Format('Events/msec: %5.2f',
        [(Timercount*1000)/(timeGetTime-StartTime)]);
end;

procedure TDXTTestForm.BarTimerIntervalChange(Sender: TObject);
var x: Integer;
begin
  lInterval.Caption := 'Interval (msec): '+
    IntToStr(barTimerInterval.Position);
  for x := 0 to TimerList.Count-1 do
    TDXTimer(TimerList[x]).Interval := barTimerInterval.Position;
  barTimerCountChange(Self);  // Reinit Zeitmessung
end;

procedure TDXTTestForm.cAsyncClick(Sender: TObject);
var x: Integer;
begin
  for x := 0 to TimerList.Count-1 do
    with TDXTimer(TimerList[x]) do
      if cAsync.Checked then
      begin
        OnAsyncTimer := OnDXTimers; OnTimer := nil;
      end else
      begin
        OnTimer := OnDXTimers; OnAsyncTimer := nil;
      end;
  barTimerCountChange(Self);  // Reinit Zeitmessung
end;

end.
