package doertbrexel;

import doertbrexel.util.Helper;

public class KeysPacket
{
	private static final char	KEY_HYPERSPACE	= 1;
	private static final char	KEY_FIRE		= 2;
	private static final char	KEY_THRUST		= 4;
	private static final char	KEY_RIGHT		= 8;
	private static final char	KEY_LEFT		= 0x10;

	private static final int	SIGNATURE_INDEX	= 0;
	private static final int	KEYS_INDEX		= SIGNATURE_INDEX + 6;
	private static final int	PING_INDEX		= KEYS_INDEX + 1;

	private byte[]				buffer			= new byte[PING_INDEX + 1];
	// private byte[] signature = new byte[6];
	// private byte keys;
	// public byte ping; // wird vom
	// // Server bei
	// // nchster
	// // Gelegenheit
	// // zurckgeschickt.
	// // Fr
	// // Latenzmessung.

	public KeysPacket()
	{
		buffer[SIGNATURE_INDEX] = 'c';
		buffer[SIGNATURE_INDEX + 1] = 't';
		buffer[SIGNATURE_INDEX + 2] = 'm';
		buffer[SIGNATURE_INDEX + 3] = 'a';
		buffer[SIGNATURE_INDEX + 4] = 'm';
		buffer[SIGNATURE_INDEX + 5] = 'e';
		buffer[KEYS_INDEX] = '@';
		buffer[PING_INDEX] = 0;
	}

	// alle Tasten loslassen
	public void clear()
	{
		buffer[KEYS_INDEX] = '@';
		if (Constants.TRACE)
			System.out.println("clear");
	}

	// Hyperspace drcken (true) oder loslassen (false)
	public void hyperspace(boolean b)
	{
		if (b)
			buffer[KEYS_INDEX] |= KEY_HYPERSPACE;
		else
			buffer[KEYS_INDEX] &= ~KEY_HYPERSPACE;
		if (Constants.TRACE_KeyPacket)
			System.out.println("hyperspace(" + b + ")");
	}

	// Feuerknopf drcken (true) oder loslassen (false)
	public void fire(boolean b)
	{
		if (b)
			buffer[KEYS_INDEX] |= KEY_FIRE;
		else
			buffer[KEYS_INDEX] &= ~KEY_FIRE;
		if (Constants.TRACE_KeyPacket)
			System.out.println("fire(" + b + ")");
	}

	// Beschleunigen ...
	public void thrust(boolean b)
	{
		if (b)
			buffer[KEYS_INDEX] |= KEY_THRUST;
		else
			buffer[KEYS_INDEX] &= ~KEY_THRUST;
		if (Constants.TRACE_KeyPacket)
			System.out.println("thrust(" + b + ")");
	}

	// links drehen
	public void left(boolean b)
	{
		if (b)
		{
			buffer[KEYS_INDEX] |= KEY_LEFT;
			right(false);
		} else
			buffer[KEYS_INDEX] &= ~KEY_LEFT;
		if (Constants.TRACE_KeyPacket)
			System.out.println("left(" + b + ")");
	}

	// rechts drehen ...
	public void right(boolean b)
	{
		if (b)
		{
			buffer[KEYS_INDEX] |= KEY_RIGHT;
			left(false);
		} else
			buffer[KEYS_INDEX] &= ~KEY_RIGHT;
		if (Constants.TRACE_KeyPacket)
			System.out.println("right(" + b + ")");
	}

	public byte[] getBuffer()
	{
		return buffer;
	}

	public byte incrementPing()
	{
		return ++buffer[PING_INDEX];
	}

	public String toString()
	{
		return new String(buffer, 0, 6) + Helper.toHexString(buffer[KEYS_INDEX])
				+ Helper.toHexString(buffer[PING_INDEX]);
	}

}
