package doertbrexel;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import doertbrexel.operations.HaltOperation;
import doertbrexel.operations.Operation;
import doertbrexel.operations.OperationFactory;
import doertbrexel.util.Helper;

public class VectorProcessor
{
	private final List<Operation>	mOperations	= new ArrayList<Operation>();

	public VectorProcessor(final FramePacket pFramePacket)
	{
		final ByteArrayInputStream frameBufferInputStream = pFramePacket.getVectorRam();
		Operation operation = null;
		// int i = 0;
		final OperationFactory operationFactory = new OperationFactory(
				frameBufferInputStream);
		while (frameBufferInputStream.available() > 0)
		{
			operation = operationFactory.next();
			mOperations.add(operation);
			// Helper.trace(new Object[]{"[" , i++ , "] " , operation});
			if (operation instanceof HaltOperation)
			{
				break;
			}
		}
	}

	public GameStatus process()
	{
		GameStatus gameStatus = new GameStatus();
		ProcessorContext processorContext = new ProcessorContext();
		int i = 0;
		// Iteration ber alle Operationen
		for (final Iterator<Operation> iterator = mOperations.iterator(); iterator
				.hasNext();)
		{
			final Operation operation = iterator.next();
			Helper.trace(new Object[]
			{"[", i++, "] ", operation});
			operation.execute(processorContext, gameStatus);
		}
		gameStatus.evaluate();
		return gameStatus;
	}

}
