package doertbrexel.operations;

import doertbrexel.GameStatus;
import doertbrexel.ProcessorContext;

public abstract class Operation
{
	public static final int	OPCODE_VCTR_MIN	= 0x0;
	public static final int	OPCODE_VCTR_MAX	= 0x9;
	public static final int	OPCODE_LABS		= 0xA;
	public static final int	OPCODE_HALT		= 0xB;
	public static final int	OPCODE_JSRL		= 0xC;
	public static final int	OPCODE_RTSL		= 0xD;
	public static final int	OPCODE_JMPL		= 0xE;
	public static final int	OPCODE_SVEC		= 0xF;

	int						mOpcode			= -1;
	int						mFirstWord		= -1;
	int						mAddressPointer	= -1;

	protected Operation(final int pAddressPointer, final int pOpcode, final int pFirstWord)
	{
		mOpcode = pOpcode;
		mFirstWord = pFirstWord;
		mAddressPointer = pAddressPointer;
	}

	//	public static Operation getInstance(ByteArrayInputStream pVectorRamInputStream)
	//	{
	//		int addressPointer = 0;
	//		int rightByte = pVectorRamInputStream.read() & 0x000000FF;
	//		addressPointer++;
	//		int leftByte = pVectorRamInputStream.read() & 0x000000FF;
	//		addressPointer++;
	//		int opcode = (leftByte & 0x000000F0) >>> 4;
	//		int firstWord = ((leftByte & 0x0000000F) << 8) | rightByte;
	//		if (opcode >= OPCODE_VCTR_MIN && opcode <= OPCODE_VCTR_MAX)
	//		{
	//			return new VctrOperation(opcode, firstWord, getNextWord(pVectorRamInputStream));
	//		} else if (opcode == OPCODE_LABS)
	//			return new LabsOperation(opcode, firstWord, getNextWord(pVectorRamInputStream));
	//		else if (opcode == OPCODE_HALT)
	//			return new HaltOperation(opcode, firstWord);
	//		else if (opcode == OPCODE_JSRL)
	//			return new JsrlOperation(opcode, firstWord);
	//		else if (opcode == OPCODE_RTSL)
	//			return new RtslOperation(opcode, firstWord);
	//		else if (opcode == OPCODE_JMPL)
	//			return new JmplOperation(opcode, firstWord);
	//		else if (opcode == OPCODE_SVEC)
	//			return new SvecOperation(opcode, firstWord);
	//		else
	//			return null;
	//	}
	//
	//	private static int getNextWord(ByteArrayInputStream pVectorRam)
	//	{
	//		int rightByte = pVectorRam.read() & 0x000000FF;
	//		int leftByte = pVectorRam.read() & 0x000000FF;
	//		int word = (leftByte << 8) | rightByte;
	//		return word;
	//	}

	public int getOpcode()
	{
		return mOpcode;
	}

	public String toString()
	{
		return "opCode=" + mOpcode + " firstWord=$" + toHexString(mFirstWord);
	}

	protected String toHexString(final int pInt)
	{
		final String hexString = "0000" + Integer.toHexString(pInt);
		return hexString.substring(hexString.length() - 4);
	}

	protected String getAddress()
	{
		return "[" + toHexString(mAddressPointer) + "]";
	}

	public boolean execute(ProcessorContext pProcessorContext, GameStatus pGameStatus)
	{
		pProcessorContext.setAddressPointer(mAddressPointer);
		return false;
	}
}
