package doertbrexel.spaceobjects;

import doertbrexel.util.Vector2D;

public class SpaceShip extends SpaceObject
{
	// Blickrichtung des Schiffes
	Vector2D	mDirection	= null;

	public SpaceShip(final int pX, final int pY, final int pDx, final int pDy)
	{
		super(pX, pY);
		mDirection = new Vector2D(pDx, pDy);
	}

	public int turnDirection(SpaceObject pSpaceObject)
	{

		// Mathematisch wird hier das Kreuzprodukt aus den Vektoren
		// ship_dx/y/0 und min_dx/y/0 berechnet
		int val = mDirection.multiply(pSpaceObject.mDelta2Ship);
		//int val = (mDx * pSpaceObject.mDyFromShip) - (mDy * pSpaceObject.mDxFromShip);
		if (val > 0)
			return -1;
		if (val < 0)
			return 1;
		return 0;
	}
}
