#include "aimath.h"



Vector3::Vector3():
	x(0.0),y(0.0),z(0.0)
{
}

Vector3::Vector3(const Vector3 &other)
{
	*this = other;
}

Vector3::Vector3(const QPointF &point, double zVal):
	x(point.x()),y(point.y()),z(zVal)
{
}

Vector3::Vector3(double xVal, double yVal, double zVal):
	x(xVal),y(yVal),z(zVal)
{
}
		
Vector3::~Vector3()
{
}

		
Vector3::operator QPointF() const
{
	return QPointF(x, y);
}

Vector3& Vector3::operator = (const Vector3 &other)
{
	x = other.x;
	y = other.y;
	z = other.z;
	return *this;
}

Vector3 Vector3::operator + (const Vector3 &vector) const
{
	return Vector3(x + vector.x, y + vector.y, z + vector.z);
}

Vector3 Vector3::operator - (const Vector3 &vector) const
{
	return Vector3(x - vector.x, y - vector.y, z - vector.z);
}


Vector3 Vector3::vectorProduct(const Vector3 &other) const
{
	return Vector3
	(
		y * other.z - z * other.y ,
	  -(x * other.z - z * other.x), 
	    x * other.y - y * other.x
	);
}

double Vector3::scalarProduct(const Vector3 &other) const
{
	return x * other.x + y * other.y + z * other.z;
}

double Vector3::length() const
{
	return sqrt(x * x + y * y + z * z);
}

void Vector3::normalize()
{
	double l = length();
	if(l <= 0.001)
	{
		x = 0.0;
		y = 0.0;
		z = 0.0;
	}
	else
	{
		*this = *this / length();
	}
}

Vector3 operator * (const Vector3 &vector, double factor)
{
	return Vector3(vector.x * factor, vector.y * factor, vector.z * factor);
}

Vector3 operator * (double factor, const Vector3 &vector)
{
	return Vector3(vector.x * factor, vector.y * factor, vector.z * factor);
}


Vector3 operator / (const Vector3 &vector, double factor)
{
	return Vector3(vector.x / factor, vector.y / factor, vector.z / factor);
}

			
		

QPair<double, double> AIMath::SolveQuad(double a, double b, double c, bool &solution)
{
	solution = false;
	double res1 = 0.0;
	double res2 = 0.0;

	if(a != 0.0)
	{
		double rootArg = b * b - 4 * a * c;
		if(rootArg >= 0.0)
		{
			double root = sqrt(rootArg);
			res1 = (-b + root) / (2 * a);
			res2 = (-b - root) / (2 * a);
			solution = true;
		}
	}
	// lineare Gleichung
	else if(b != 0.0)
	{
		res1 = res2 = -c / b;
		solution = true;
	}
	
	return QPair<double, double>(res1,res2); 

}