#ifndef FRAMEDATA_H
#define FRAMEDATA_H


#include "aitest.h"







class MovingObject
{
	public:
		enum Type
		{
			Asteroid,
			Saucer,
			Ship,
			Shot,
		};
		MovingObject(Type tp);
		~MovingObject();
		void addVelocitySample(const QPointF &sample);
		void copySamples(const MovingObject &other);

		// Position
		QPointF position;

		// Geschwindigkeitsvektor
		QPointF vVec;

		// Geschwindigkeit absolut
		double velocity;

		// Ist Geschwindigkeit berechnet?
		bool hasSpeed;

		// Typ
		Type type;

	
	private:

		// Velocity Samples
		QList<QPointF> velocitySamples;
};


class Target:public MovingObject
{
	public:
		enum Size
		{
			Big = 0,
			Medium = 15,
			Small = 14,
			Unknown = 13,
		};
		Target(Type tp);
		Target(Size sz, Type tp);
		~Target();
		void forget(int shots);
		
		// Gre
		Size size;

		// Aimed und Beschossen??
		bool targeded;

		// Leben fr Mehrfachbeschuss
		int lives;


		// Verbindungsnormale zum Schiff (Schiff->Asteroid\UFO)
		QPointF vTarget;
		//QPointF vTargetF;

		// Abstand zum Schiff
		double distTarget;
	
		double angAstF;
		double dAngSAF;

		double timeToDeath;

		double shootAngle;
		bool inRange;
		double timeToKill;
		double selectionValue;

		// Zhlvarible um Asteroid eine Zeitlang zu ignorieren
		int ignoreTimeout;

		bool miss;


};


class ShipData:public MovingObject
{
	public:
		ShipData();
		~ShipData();
		void clear();
		bool match(ShipData *l);

		// Letzte Daten
		ShipData *last;

		// Blickwinkel
		double angle;

		// Blickrichtung
		QPointF heading;

		// Sichtbar?
		bool visible;
};


class SaucerData:public Target
{
	public:
		SaucerData();
		~SaucerData();
		void clear();
		bool match(SaucerData *l);

		// Letzte Daten
		SaucerData *last;

		// Anwesend?
		bool present;

	private:

		// Velocity Samples
		//QList<QPointF> velocitySamples;
};

class ShotData:public MovingObject
{
	public:
		enum Owner
		{
			Unknown = 0,
			Mine = 1,
			Alien = 2,
			
		};
		ShotData(const QPointF &ps);
		~ShotData();
		bool match(ShotData *l);
		double tryMatch(ShotData *l);

		// Die letzten Daten
		ShotData *last;

		// Der Besitzer
		Owner owner;


		// Debug
		void print();
		double eval;

};

class AsteroidData:public Target
{
	public:
		AsteroidData(const QPointF &ps, int lk, Target::Size sz);
		~AsteroidData();
		bool match(AsteroidData *l);
		

		// Aussehen
		int look;
	
		

		// Letzte Daten
		AsteroidData *last;

	

		// Ist auf Kollisionskurs?
		bool willCollide;


		//****************************
		// Debug
		//****************************
		QColor color;


};

class FrameData
{
	public:
		FrameData();
		~FrameData();
		void clear();
		void asteroidFound(int x, int y, int type, int scale);
		void saucerFound(int x, int y, int scale);
		void shipFound(int x, int y, int dX, int dY);
		void shotFound(int x, int y);

		// Schiffs Daten
		ShipData shipData;

		// UFO Daten
		SaucerData saucerData;

		// Die Schsse
		QList<ShotData*> shotDataList;


		// Alle Asteroiden die eine Bedrohung darstellen
		QList<AsteroidData*> threadList;

		// Die Asteroiden
		QList<AsteroidData*> asteroidDataList;

		// Alle Targets Asteroiden + UFO
		QList<Target*> targetList;

		// Alle beweglichen Objkte
		QList<MovingObject*> movingObjectList;
		
		// Gibt ab ob ein UFO schiest und treffen wird
		bool deadlyFire;

	private:
		void addAsteroid(AsteroidData *as);



};





















#endif