#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "aitest.h"


class Messanger;
class Config;
class MameView;
class MameScene;
class Socket;

struct Actions
{
	QAction *start;
	QAction *exit;
};
typedef struct Actions Actions;

struct Menus
{
	QMenu *fileMenu;
	QMenu *viewMenu;
};
typedef struct Menus Menus;

struct ToolBars
{
	QToolBar *fileToolBar;
};
typedef struct ToolBars ToolBars;

struct DockWidgets
{
	Messanger *messanger;
	Config *config;
};
typedef struct DockWidgets DockWidgets;

class MainWindow:public QMainWindow
{
	Q_OBJECT

	public:
		MainWindow();
		~MainWindow();
	private:
		void createActions();
		void createMenus();
		void createToolBars();
		void createDockWidgets();

		Actions actions;
		Menus menus;
		ToolBars toolBars;
		DockWidgets dockWidgets;

		MameView *mameView;
		MameScene *mameScene;

		Socket *socket;
		
	private slots:
		void start();
		void exit();

};


#endif