
#include "mamescene.h"

#include "mameview.h"
#include "ship.h"
#include "saucer.h"
#include "asteroid.h"
#include "framedata.h"

#define CROSSIZE 100.0

QPainterPath* MameScene::cross = 0;

MameScene::MameScene(MameView *mv):
	QGraphicsScene(mv),mameView(mv)
{
	ai->setMameScene(this);

	setSceneRect(-524.0, -396.0, 1024.0, 768.0);
	setBackgroundBrush(Qt::black);

	ship = new Ship();
	addItem(ship);

	saucer = new Saucer();
	addItem(saucer);


	Asteroid::GenPathes();
	for(int i = 0; i < MAX_ASTEROIDS; i++)
	{
		Asteroid *asteroid = new Asteroid;
		asteroidList << asteroid;
		addItem(asteroid);
		asteroid->setVisible(false);
	}

	genHelpPathes();


}

MameScene::~MameScene()
{
}

void MameScene::progress()
{
	FrameData *frameData = ai->getLast();
	
	// Schiff darstellen
	ship->setData(&(frameData->shipData));

	// UFO darstellen
	saucer->setData(&(frameData->saucerData));

	// Asteroiden darstellen
	for(int i = 0; i < asteroidList.size(); i++)
	{
		if(frameData->asteroidDataList.size() > i)
		{
			asteroidList[i]->setData(frameData->asteroidDataList[i]);
			asteroidList[i]->setVisible(true);
		}
		else
		{
			asteroidList[i]->setVisible(false);
		}

	}

	// Eigentlich zeichnen
	mameView->viewport()->update();
}

void MameScene::drawBackground( QPainter *painter, const QRectF &rect)
{
	QGraphicsScene::drawBackground(painter,rect);
	FrameData *frameData = ai->getLast();
	
	// Die Schsse
	painter->save();
	painter->setPen(Qt::NoPen);
	painter->setBrush(QColor(255,255,255));
	
	

	for(int i = 0; i < frameData->shotDataList.size(); i++)
	{
		ShotData *shotData = frameData->shotDataList[i];
		painter->save();
		if(shotData->hasSpeed)
		{
			switch(shotData->owner)
			{
				case ShotData::Alien:
					painter->setBrush(Qt::red);
					break;
				case ShotData::Mine:
					painter->setBrush(Qt::green);
					break;
				default:
					break;
			}
			
		}
		QRectF rect(-8.0, -8.0, 16.0, 16.0);
		rect.moveCenter(shotData->position);
		painter->drawEllipse(rect);
		painter->restore();
	}
	painter->restore();

	// Hilfslinien
	
	if(frameData->shipData.visible && Options::ShowCross)
	{
		painter->save();
		QPen pen = painter->pen();
		pen.setWidthF(3.0);
		pen.setBrush(Qt::green);
		painter->setPen(pen);
		painter->translate(frameData->shipData.position);
		painter->drawPath(*cross);
		painter->rotate(frameData->shipData.angle);
		pen.setBrush(Qt::red);
		painter->setPen(pen);
		painter->drawPath(*cross);
		painter->restore();
	}
	

}

void MameScene::keyPressEvent(QKeyEvent *keyEvent)
{
	switch(keyEvent->key())
	{
		case Qt::Key_Left:
			ai->actionLeft(true);
			break;
		case Qt::Key_Right:
			ai->actionRight(true);
			break;
		case Qt::Key_Up:
			ai->actionThrust(true);
			break;
		case Qt::Key_Control:
			ai->actionFire(true);
			break;
		case Qt::Key_Space:
			ai->actionHyperspace(true);
			break;
		case Qt::Key_C:
			Messanger::Post() << ai->getLast()->shipData.angle;
			break;
		case Qt::Key_I:
			Options::PrintInfo = true;
			break;
		default:
			break;
	}
}

void MameScene::keyReleaseEvent(QKeyEvent *keyEvent)
{
	switch(keyEvent->key())
	{
		case Qt::Key_Left:
			ai->actionLeft(false);
			break;
		case Qt::Key_Right:
			ai->actionRight(false);
			break;
		case Qt::Key_Up:
			ai->actionThrust(false);
			break;
		case Qt::Key_Control:
			ai->actionFire(false);
			break;
		case Qt::Key_Space:
			ai->actionHyperspace(false);
			break;
		case Qt::Key_I:
			Options::PrintInfo = false;
			break;
		default:
			break;
	}
}


void MameScene::genHelpPathes()
{
	cross = new QPainterPath(QPointF(0.0, 0.0));
	cross->moveTo(-CROSSIZE / 2.0, 0.0);
	cross->lineTo(CROSSIZE / 2.0, 0.0);
	cross->moveTo(0.0, -CROSSIZE / 2.0);
	cross->lineTo(0.0, CROSSIZE / 2.0);
}