#include "saucer.h"

#include "framedata.h"

Saucer::Saucer():
	QGraphicsItem(),data(0)
{
	createPath();
	setVisible(false);
}


Saucer::~Saucer()
{
}

void Saucer::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
	if(data)
	{
		painter->save();
		switch(data->size)
		{
			case Target::Small:
				painter->scale(0.5, 0.5);
				break;
			case Target::Medium:
			default:
				break;
		}
		painter->scale(1.0, -1.0);
		painter->setPen(Qt::white);
		painter->drawPath(*saucerPath);
		painter->restore();
		if(data->hasSpeed)
		{
			
			QPen pen = painter->pen();
			pen.setWidthF(4.0);
			pen.setColor(Qt::red);
			painter->setPen(pen);
			
			painter->drawLine(QPointF(0.0, 0.0), data->velocity * 25 * data->vVec);
		}
	}
}

QRectF Saucer::boundingRect() const
{
	return QRectF(-50.0, -50.0, 100.0, 100.0);
}

void Saucer::setData(SaucerData *sd)
{
	data = sd;
	setPos(data->position);
	setVisible(data->present);
}

void Saucer::createPath()
{
	saucerPath = new QPainterPath(QPointF(0.0, 0.0));
	saucerPath->moveTo(-6.0, -14.0);
	saucerPath->lineTo(6.0, -14.0);
	saucerPath->lineTo(11.0, -4.0);
	saucerPath->lineTo(24.0, 5.0);
	saucerPath->lineTo(11.0, 14.0);
	saucerPath->lineTo(-11.0, 14.0);
	saucerPath->lineTo(-24.0, 5.0);
	saucerPath->lineTo(-11.0, -4.0);
	saucerPath->lineTo(-6.0, -14.0);

	saucerPath->moveTo(-11.0, -4.0);
	saucerPath->lineTo(11.0, -4.0);

	saucerPath->moveTo(-24.0, 5.0);
	saucerPath->lineTo(24.0, 5.0);



}