#include "ship.h"

#include "framedata.h"


Ship::Ship():
	QGraphicsItem(),data(0)
{
	createPath();
	setVisible(false);
}

Ship::~Ship()
{
}

void Ship::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
	if(data)
	{
		painter->save();
		painter->rotate(data->angle);
		painter->scale(1.0, -1.0);
		painter->setPen(Qt::white);
		painter->drawPath(*shipPath);
		painter->restore();
		if(data->hasSpeed)
		{
			QPen pen = painter->pen();
			pen.setWidthF(4.0);
			pen.setColor(Qt::red);
			painter->setPen(pen);
			
			painter->drawLine(QPointF(0.0, 0.0), data->velocity * 25 * data->vVec);
		}
	}
}

QRectF Ship::boundingRect() const
{
	return QRectF(-50.0, -50.0, 100.0, 100.0);
}


void Ship::setData(ShipData *sd)
{
	data = sd;
	setPos(data->position);
	setVisible(data->visible);
}


void Ship::createPath()
{
	shipPath = new QPainterPath(QPointF(0.0, 0.0));
	shipPath->moveTo(-8.0, -10.0);
	shipPath->lineTo(21.0, 0.0);
	shipPath->lineTo(-8.0, 10.0);
	shipPath->lineTo(-3.0, 5.0);
	shipPath->lineTo(-3.0, -5.0);
	shipPath->lineTo(-8.0, -10.0);
}
