// player.h: Beispielspieler fr Asteroids
// Original von Harald Bgeholz / c't
// 29.06.2008
// erweitert von Olaf Ehbrecht, Hamburg, ( oehbrecht@web.de )
// unter Verwendung der Schusswinkeldatei von AnDann

#include <stdio.h>
#include <iostream>
#include <string.h>
#include <time.h>

#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

using namespace std;

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;

static double shot_direction[] = {
0.0,
3.6,
8.2,
12.7,
16.5,
21.2,
25.2,
29.5,
33.5,
37.8,
41.7,
46.2,
50.8,
55.3,
59.4,
63.4,
67.5,
71.6,
76.1,
79.9,
84.5,
89.1,
92.8,
97.2,
101.8,
105.5,
110.2,
114.1,
118.1,
122.8,
126.7,
131.1,
135.0,
139.4,
143.3,
147.9,
151.9,
156.6,
160.7,
164.5,
169.2,
172.8,
177.3,
181.9,
185.5,
189.9,
194.5,
198.2,
203.0,
206.9,
211.0,
215.4,
220.0,
223.8,
227.5,
232.2,
235.9,
240.3,
245.1,
248.8,
252.7,
257.3,
261.1,
265.6,
270.0,
273.6,
278.2,
282.7,
286.5,
291.2,
295.0,
299.0,
303.5,
307.8,
311.7,
316.2,
320.0,
324.5,
328.6,
332.7,
336.6,
341.6,
345.3,
349.9,
354.5,
358.1,
2.8,
7.2,
11.0,
15.5,
19.3,
23.4,
28.1,
32.8,
36.7,
40.6,
45.0,
49.4,
53.3,
57.2,
61.9,
66.6,
70.7,
74.5,
79.0,
82.8,
87.2,
91.9,
95.5,
100.1,
104.7,
108.4,
113.4,
117.3,
121.4,
125.6,
130.0,
133.8,
138.3,
142.2,
146.5,
151.0,
155.0,
158.8,
163.6,
167.3,
171.8,
176.6,
180.0,
184.4,
188.9,
192.7,
197.3,
201.2,
205.0,
209.7,
214.2,
217.8,
222.5,
226.2,
230.0,
234.6,
239.0,
243.1,
247.0,
251.8,
255.5,
260.1,
264.5,
268.1,
272.7,
277.2,
280.8,
285.5,
289.3,
293.4,
298.1,
302.2,
306.7,
310.6,
315.0,
318.9,
323.3,
327.2,
331.9,
335.9,
339.8,
344.5,
348.2,
352.8,
357.2,
0.9,
5.5,
10.1,
13.9,
18.4,
22.5,
26.6,
30.6,
34.7,
39.2,
43.8,
48.3,
52.2,
56.5,
60.5,
64.7,
68.8,
73.5,
77.3,
81.8,
86.4,
90.0,
94.5,
98.9,
102.7,
107.3,
111.2,
115.3,
120.2,
124.2,
127.8,
132.5,
136.1,
140.8,
145.3,
149.8,
153.9,
157.9,
161.8,
166.3,
170.1,
174.3,
179.1,
182.9,
187.2,
191.5,
195.6,
200.3,
204.1,
208.1,
212.1,
216.6,
221.0,
225.0,
228.9,
233.3,
237.8,
241.9,
245.9,
249.8,
254.5,
258.4,
262.8,
267.3,
270.9,
275.5,
279.9,
283.7,
288.2,
292.1,
296.1,
300.2,
304.7,
309.2,
313.8,
317.5,
322.2,
325.8,
329.8,
334.7,
338.8,
342.7,
347.2,
351.1,
355.5
};

static double shot_dir_sorted[] = {
0.0,
0.9,
2.8,
3.6,
5.5,
7.2,
8.2,
10.1,
11.0,
12.7,
13.9,
15.5,
16.5,
18.4,
19.3,
21.2,
22.5,
23.4,
25.2,
26.6,
28.1,
29.5,
30.6,
32.8,
33.5,
34.7,
36.7,
37.8,
39.2,
40.6,
41.7,
43.8,
45.0,
46.2,
48.3,
49.4,
50.8,
52.2,
53.3,
55.3,
56.5,
57.2,
59.4,
60.5,
61.9,
63.4,
64.7,
66.6,
67.5,
68.8,
70.7,
71.6,
73.5,
74.5,
76.1,
77.3,
79.0,
79.9,
81.8,
82.8,
84.5,
86.4,
87.2,
89.1,
90.0,
91.9,
92.8,
94.5,
95.5,
97.2,
98.9,
100.1,
101.8,
102.7,
104.7,
105.5,
107.3,
108.4,
110.2,
111.2,
113.4,
114.1,
115.3,
117.3,
118.1,
120.2,
121.4,
122.8,
124.2,
125.6,
126.7,
127.8,
130.0,
131.1,
132.5,
133.8,
135.0,
136.1,
138.3,
139.4,
140.8,
142.2,
143.3,
145.3,
146.5,
147.9,
149.8,
151.0,
151.9,
153.9,
155.0,
156.6,
157.9,
158.8,
160.7,
161.8,
163.6,
164.5,
166.3,
167.3,
169.2,
170.1,
171.8,
172.8,
174.3,
176.6,
177.3,
179.1,
180.0,
181.9,
182.9,
184.4,
185.5,
187.2,
188.9,
189.9,
191.5,
192.7,
194.5,
195.6,
197.3,
198.2,
200.3,
201.2,
203.0,
204.1,
205.0,
206.9,
208.1,
209.7,
211.0,
212.1,
214.2,
215.4,
216.6,
217.8,
220.0,
221.0,
222.5,
223.8,
225.0,
226.2,
227.5,
228.9,
230.0,
232.2,
233.3,
234.6,
235.9,
237.8,
239.0,
240.3,
241.9,
243.1,
245.1,
245.9,
247.0,
248.8,
249.8,
251.8,
252.7,
254.5,
255.5,
257.3,
258.4,
260.1,
261.1,
262.8,
264.5,
265.6,
267.3,
268.1,
270.0,
270.9,
272.7,
273.6,
275.5,
277.2,
278.2,
279.9,
280.8,
282.7,
283.7,
285.5,
286.5,
288.2,
289.3,
291.2,
292.1,
293.4,
295.0,
296.1,
298.1,
299.0,
300.2,
302.2,
303.5,
304.7,
306.7,
307.8,
309.2,
310.6,
311.7,
313.8,
315.0,
316.2,
317.5,
318.9,
320.0,
322.2,
323.3,
324.5,
325.8,
327.2,
328.6,
329.8,
331.9,
332.7,
334.7,
335.9,
336.6,
338.8,
339.8,
341.6,
342.7,
344.5,
345.3,
347.2,
348.2,
349.9,
351.1,
352.8,
354.5,
355.5,
357.2,
358.1
};

static int shot_dir_sorted_idx[] = {
0,
171,
86,
1,
172,
87,
2,
173,
88,
3,
174,
89,
4,
175,
90,
5,
176,
91,
6,
177,
92,
7,
178,
93,
8,
179,
94,
9,
180,
95,
10,
181,
96,
11,
182,
97,
12,
183,
98,
13,
184,
99,
14,
185,
100,
15,
186,
101,
16,
187,
102,
17,
188,
103,
18,
189,
104,
19,
190,
105,
20,
191,
106,
21,
192,
107,
22,
193,
108,
23,
194,
109,
24,
195,
110,
25,
196,
111,
26,
197,
112,
27,
198,
113,
28,
199,
114,
29,
200,
115,
30,
201,
116,
31,
202,
117,
32,
203,
118,
33,
204,
119,
34,
205,
120,
35,
206,
121,
36,
207,
122,
37,
208,
123,
38,
209,
124,
39,
210,
125,
40,
211,
126,
41,
212,
127,
42,
213,
128,
43,
214,
129,
44,
215,
130,
45,
216,
131,
46,
217,
132,
47,
218,
133,
48,
219,
134,
49,
220,
135,
50,
221,
136,
51,
222,
137,
52,
223,
138,
53,
224,
139,
54,
225,
140,
55,
226,
141,
56,
227,
142,
57,
228,
143,
58,
229,
144,
59,
230,
145,
60,
231,
146,
61,
232,
147,
62,
233,
148,
63,
234,
149,
64,
235,
150,
65,
236,
151,
66,
237,
152,
67,
238,
153,
68,
239,
154,
69,
240,
155,
70,
241,
156,
71,
242,
157,
72,
243,
158,
73,
244,
159,
74,
245,
160,
75,
246,
161,
76,
247,
162,
77,
248,
163,
78,
249,
164,
79,
250,
165,
80,
251,
166,
81,
252,
167,
82,
253,
168,
83,
254,
169,
84,
255,
170,
85
};

int round( double );
double calc_collision_window( int distance, int radius );
double diff_degree( double a, double b );
void sleep( clock_t wait );

class Direction
{
public:
	double dx;
	double dy;

	Direction();
	Direction(const Direction &);
	Direction& operator=(const Direction &);

	void set(double dx, double dy);
	void clear(void);
	double getInDegree(void) const;

	friend ostream& operator<<( ostream& , const Direction& );
};

class Speed
{
public:
	double dx;
	double dy;

	Speed();
	Speed(const double, const double);
	Speed(const Speed &);
	Speed& operator=(const Speed &);

	void set(double dx, double dy);
	void clear(void);
	double getDistance(void);

	friend ostream& operator<<( ostream& , const Speed& );
};

class Distance
{
public:
	int		total_distance;
	double	distance_per_time;
	double	dx;
	double	dy;
	double	degree;
	double	collision_window;
	int		collision_time;
	int		asteroid_number;

	Speed	object_speed;

	Distance();
	Distance( int total_distance );
	Distance(const Distance &);
	Distance& operator=(const Distance &);

	void set(int total_distance, Speed current_speed, double dx, double dy, int asteroid_number);
	void set_collision_window(int radius);
	void clear(void);
	bool is_cleared(void);
	bool is_asteroid(void);

	friend ostream& operator<<( ostream& , const Distance& );

};

class Position
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int t;	  // Zeitpunkt der Beobachtung

	Position();
	Position(const Position &);
	Position& operator=(const Position &);

	friend Speed operator-( const Position&, const Position& );

	void set(int t, int x, int y);
	void clear(void);
	bool is_cleared(void);
	int distance( const Position& b );
	double degree( const Position& b );

	friend ostream& operator<<( ostream& , const Position& );
};

class Asteroid
{
public:
	Position	current_pos;
	Position	last_pos;
	Position	start_pos;
	Direction   current_dir;
	Speed       current_speed;
	bool		recalc_possible;
	bool		targeted;
	int			targeted_expected_time_to_hit;
	int			targeted_count;

	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein

	int dx;	  // Distanz zum letzten Mittelpunkt
	int dy;

	Asteroid();
	Asteroid(const Asteroid &);
	Asteroid& operator=(const Asteroid &);

	void set_current(int t, int x, int y, int type, int sf);
	void recalc(void);
	bool is_targeted( int current_t );
	void mark_as_targeted( int current_t );
	Position get_next_pos( int t );

	friend ostream& operator<<( ostream& , const Asteroid& );
};

class Shot
{
public:
	Position	current_pos;
	Direction   current_dir;
	Speed       current_speed;
	Position	last_pos;
	Position	start_pos;
	bool		recalc_possible;
	bool		own_shot;

	Shot();
	Shot(const Shot &);
	Shot& operator=(const Shot &);
	void set_current(int t, int x, int y);
	void recalc(void);
	Position get_next_pos( int t );

	friend ostream& operator<<( ostream& , const Asteroid& );
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	Position	current_ship_pos;		// Mittelpunkt des Schiffs

	Direction   current_ship_dir;		// Blickrichtung des Schiffes
	Speed       current_ship_speed;		// relative Geschwindigkeit
	int			ship_shot_pos;
	Position	last_ship_pos;
	Position	start_ship_pos;

	bool		saucer_present;// UFO sichtbar
	bool		saucer_targeted;
	int			saucer_targeted_etot;

	Position	current_saucer_pos;		// Mittelpunkt des UFOs
	Direction   current_saucer_dir;		// Flugrichtung des UFOs
	Speed       current_saucer_speed;	// relative Geschwindigkeit
	int			saucer_size;    // Gre: 15 = gro, 14 = klein
	Position	last_saucer_pos;
	Position	start_saucer_pos;


	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];

	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];

	GameStatus();
	GameStatus(const GameStatus &);
	GameStatus& operator=(const GameStatus &);

	double delta_in_degree( Distance target, double *eth );

	bool saucer_is_targeted( int current_t );
	void mark_saucer_as_targeted( int current_t );

	friend ostream& operator<<( ostream& , const GameStatus& );

	void clear(void);
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	KeysPacket(const KeysPacket &);
	KeysPacket& operator=(const KeysPacket &);

	friend ostream& operator<<( ostream& , KeysPacket& );

	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen

	bool ishyperspace(void);
	bool isfire(void);
	bool isthrust(void);
	bool isright(void);
	bool isleft(void);
};

class Statistic
{
public:
	int		key_fire;
	int		key_hyperspace;
	int		key_left;
	int		key_right;

	int		targeted;
	int		retargeted;

	Statistic();
	void add_key(KeysPacket key);
	void add_targeted();
	void add_retargeted();

	friend ostream& operator<<( ostream& , const Statistic& );
};

class IntroPacket
{
private:
	char signature[38];
public:
	IntroPacket(void);
};

#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(int t, FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
	void SendPlayerName();
private:
	SOCKET sd;
	ADDRESS server_ip;
};
