#ifndef ASTEROIDSIZE_H_
#define ASTEROIDSIZE_H_

class AsteroidSize
{
private:
	unsigned int size;
	
	//verhindere die globale Erzeugung beliebiger Größen
	AsteroidSize(unsigned int size);
public:
	
	unsigned int getValue() const;
	
	bool operator==(const AsteroidSize& ref) const;
	
	bool operator!=(const AsteroidSize& ref) const;
	
	static const AsteroidSize small; 
	static const AsteroidSize medium;
	static const AsteroidSize big;

};

inline unsigned int AsteroidSize::getValue() const
{
	return this->size;
}

inline bool AsteroidSize::operator==(const AsteroidSize& ref) const
{
	return size-ref.size == 0;
}

inline bool AsteroidSize::operator!=(const AsteroidSize& ref) const
{
	return size-ref.size != 0;
}

#endif
