#ifndef RINGLIST_H_
#define RINGLIST_H_

template<class T, int n=9>
class RingList
{
private:
	class RingElement
	{
	private:
		friend class RingList<T,n>;
		T data;
		RingElement*next;
		RingElement*prev;
	public:
		RingElement(T&data):data(data),next(0),prev(0)
		{
		}
	};
	RingElement* first;
	RingElement*last;
	
	int maxNumber;
	int length;

	
public:
	RingList():first(0),last(0),maxNumber(n),length(0)
	{
	}
	
	RingList(const RingList&ref);
	
	RingList& operator=(const RingList& ref);
	
	~RingList()
	{
		for(int i = 0; i< length;i++)
		{
			last = first->next;
			delete first;
			first = last;
		}
	}
	
	void insertElement(T& data);
	
	void insertElement(T * data);
	
	T& getFirst()
	{
		return first->data;
	}
	
	T& getLast()
	{
		return last->data;
	}
	
	int getLength()
	{
		return length;
	}

	
};

template<class T, int n>
RingList<T,n>::RingList(const RingList& ref)
{
	first = last = 0;
	length = 0;
	maxNumber =n;
	
	RingElement * current = ref.first;
	
	while(current)
	{
		insertElement(current->data);
		current = current->next;
	}
}

template<class T, int n>
RingList<T,n>& RingList<T,n>::operator =(const RingList& ref)
{
	RingElement * current = ref.last;
	
	for(int i = 0; i< ref.length;i++)
	{
		insertElement(current->data);
		current = current->next;
	}
	
	return *this;
}

template<class T, int n>
void RingList<T,n>::insertElement(T* data)
{
	insertElement(*data);
	delete data;
}

template<class T, int n>
void RingList<T,n>::insertElement(T& data)
{
	if(length < maxNumber)
	{
		if(!first)
		{
			first = last = new RingElement(data);
		}
		else
		{
			first->next = new RingElement(data);
			first->next->prev =first;
			first = first->next;
			first->next = last;
			last->prev =first;
		}
		length++;
	}
	else
	{
		last->data = data;
		last = last->next;
		first= first->next;
	}
}

#endif /*RINGLIST_H_*/
