#ifndef FLYINGOBJECT_H_
#define FLYINGOBJECT_H_

#include <wx/gdicmn.h>
#include "Angle.h"

class FlyingObject
{
private:
	wxPoint absolutePosition;
	//Bewegungsrichtung
	Angle absoluteAngle;
	//Position relativ zum eigenen Schiff
	wxPoint relativePosition;
	//Richtung relativ zum eigenen Schiff
	Angle relativeAngle;

	int velocity;
	//Bewegungsvektor
	wxPoint flightVector;
	
	//Bewegunsvektor relativ zum Schiff
	wxPoint relativeFlightVector; 
	
	//aktueller Abstand
	int distance;
	
	//Anzahl Frames bis es zu einer Kollision kommt (-1 = keine Kollision)
	int framesToCollision;
	
	//ObjektID
	int objectID;
	
	int lifeTime;
	
protected:
	FlyingObject(int objectID,
	             wxPoint absolutePosition,
	             Angle   absoluteAngle,
	             wxPoint relativePosition,
	             Angle   relativeAngle,
	             int     velocity,
	             wxPoint flightVector,
	             wxPoint relativeFlightVector,
	             int     distance,
	             int     framesToCollision,
	             int lifeTime); //nur Konstruktion von abgeleiteten Klassen erlauben
	
	FlyingObject():
		absolutePosition(wxPoint(-1,-1)),
		absoluteAngle(0),
		relativePosition(wxPoint(-1,-1)),
		relativeAngle(0),
		velocity(-1),
		flightVector(0,0),
		relativeFlightVector(0,0),
		distance(-1),
		framesToCollision(-1),
		objectID(-1),
		lifeTime(-1)
		{
		}
		
public:
	virtual ~FlyingObject()
	{ }

	wxPoint getAbsolutePosition() const { return this->absolutePosition; }
	
	void setAbsolutePosition(wxPoint position)
	{
		absolutePosition = position;
	}
	
	Angle getAbsoluteAngle() const { return this->absoluteAngle; }
	
	void setAbsoluteAngle( int angle)
	{
		absoluteAngle = angle;
	}
	
	wxPoint getRelativePosition() const { return this->relativePosition; }
	
	void setRelativePoisition(wxPoint position)
	{
		relativePosition = position;
	}
	
	int getRelativeAngle() const { return this->relativeAngle; }
	
	void setRelativeAngle(int angle)
	{
		relativeAngle = angle;
	}
	
	int getVelocity() const { return this->velocity; }
	
	void setVelocity(int velocity)
	{
		this->velocity = velocity;
	}

	wxPoint getFlightVector() const { return this->flightVector; }
	
	void setFlightVector(wxPoint flightVector)
	{
		this->flightVector = flightVector;
	}
	
	wxPoint getRelativeFlightVector()
	{
		return relativeFlightVector;
	}
	
	void setRelativeFlightVector(wxPoint relativeFlightVector)
	{
		this->relativeFlightVector = relativeFlightVector;
	}
	
	int getDistance()
	{
		return distance;
	}
	
	void setDistance(int distance)
	{
		this->distance = distance;
	}
	
	int getFramesToCollision()
	{
		return framesToCollision;
	}
	
	void setFramesToCollision(int framesToCollision)
	{
		this->framesToCollision = framesToCollision;
	}
	
	virtual unsigned int getSize() const = 0;
	
	bool isUsed()
	{
		return absolutePosition.x != -1;
	}
	
	int getObjectID()
	{
		return objectID;
	}
	
	void setObjectID(int id)
	{
		objectID = id;
	}
	
	virtual int getHits()
	{
		return 1;
	}
	
	int getLifeTime()
	{
		return lifeTime;
	}
	
};

#endif /*FLYINGOBJECT_H_*/
