#ifndef _FRAME_H
#define _FRAME_H

#include "Snapshot.h"
#include "Log.h"

//wrappt einen ankommenden Frame und kann einen Snapshot damit initialisieren
class Frame
{
public:
	//statischer Puffer, damit nicht für jeden frame neu alloziert werden muss
	static char frameBuffer[1026];
	
	Frame(const char* buf);
	void operator>>(Snapshot&);
	int getFrameID() { return currentFrameID; }
	void dump();
private:
	const char* buf;
	int index;
	char currentFrameID;
	
	#if defined _LOG_IO || defined _LOG_IO_FILE
	static char lastFrameID;
	#endif
	//hash table zur berechnung des winkels
	static const char angle[451];
	
	//hilfsfunktionen für operator>>
	void parseObjects(Snapshot&);
	void parseText(Snapshot&);
};

#endif
