#ifndef IOLAYER_H_
#define IOLAYER_H_

#include "Repository.h"
#include "defines.h"

#include <iostream>

#ifdef WINDOWS
#include <windows.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <fcntl.h>
#endif

#include <map>
#include <exception>

using namespace std;

#define INVALID_SOCKET -1

class SocketException : public std::exception
{
private:
	string message;
public:
	SocketException(string message): message(message) { }
	virtual ~SocketException() throw() { }
	const char* what() const throw();
};

class IOLayer
{
private:
	//UDP-Port oeffnen
	void initializeIO(const char* server);
	//ein Snapshot-Objekt aus dem Frame erzeugen
	void analyzeFrame(char *frame);
	#define hashVector(x,y,len) ((len>>3)+(x<<1)+(y<<8))
	
	Repository* repository;
	
	unsigned long ip;
	int recSocket;
	sockaddr_in sendAddr;
	
	fd_set readfds;
	fd_set exceptfds;
	int currentFrameID;
	//Puffer für die Ausgabe, da 75% immer gleich bleiben
	unsigned char buffer[8];
	
	#ifdef _MEASURE_TIME_
	time_tsc startFrame,endFrame;
	#endif
public:
	IOLayer(const char* ip_adresse_als_string, Repository* repository);
	~IOLayer();
	void sendData();
	
	#ifdef _BOT_SINGLETHREADED_
	bool receiveData();
	#else
	void receiveData();
	#endif
};

class IOLayerSendThread:public wxThread
{
private:
	IOLayer* ioLayer;
public:
	IOLayerSendThread(IOLayer* ioLayer): ioLayer(ioLayer)
	{ }
	ExitCode Entry()
	{
		while(!TestDestroy())
			ioLayer->sendData();
		return 0;
	}
};

class IOLayerReceiveThread: public wxThread
{
private:
	IOLayer* ioLayer;
public:
	IOLayerReceiveThread(IOLayer* ioLayer): ioLayer(ioLayer)
	{ }
	ExitCode Entry()
	{
		while(!TestDestroy())
			ioLayer->receiveData();
		return 0;
	}
};

#endif /*IOLAYER_H_*/
