#ifndef MATRIX_H_
#define MATRIX_H_

class Tools;

class Matrix
{
	friend class Tools;
private:
	double matrix[3][3];
	
	Matrix()
	{
		matrix[0][0] = 1;
		matrix[1][0] = 0;
		matrix[2][0] = 0;
		matrix[0][1] = 0;
		matrix[1][1] = 1;
		matrix[2][1] = 0;
		matrix[0][2] = 0;
		matrix[1][2] = 0;
		matrix[2][2] = 1;
	}

public:
	
	Matrix(const Matrix& ref)
	{
		memcpy(matrix,ref.matrix,sizeof(matrix));
	}
	
	Matrix& operator=(const Matrix& ref)
	{
		memcpy(matrix,ref.matrix,sizeof(matrix));
		
		return *this;
	}
	
	Matrix operator*(const Matrix& ref)
	{
		Matrix newMatrix;
		
		for(int i = 0; i< 3;i++)
		{
			for(int j = 0;j<3;j++)
			{
				double result =0;
				
				for(int k = 0; k<3;k++)
				{
					result += matrix[i][k]*ref.matrix[k][j];
				}
				newMatrix.matrix[i][j] = result;
			}
		}
		
		return newMatrix;
	}
	
	void operator *=(const Matrix& ref)
	{
		Matrix newMatrix;
		for(int i = 0; i< 3;i++)
		{
			for(int j = 0;j<3;j++)
			{
				double result =0;
				
				for(int k = 0; k<3;k++)
				{
					result += matrix[i][k]*ref.matrix[k][j];
				}
				newMatrix.matrix[i][j] = result;
			}
		}
		*this = newMatrix;
	}
	
};

#endif /*MATRIX_H_*/
