/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.ACosCommand;
import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class ACosCommandTest
extends TestCase {
    private ACosCommand acosCommand = null;
    private AICommand aiCommand = null;

    public ACosCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.acosCommand = new ACosCommand();
        this.aiCommand = this.acosCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        ACosCommandTest.assertEquals("ACOS", this.acosCommand.getShortName());
        ACosCommandTest.assertEquals("ACOS", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        ACosCommandTest.assertEquals("Arcuscosinus", this.acosCommand.getLongName());
        ACosCommandTest.assertEquals("Arcuscosinus", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        ACosCommandTest.assertEquals(1, this.acosCommand.getParameterCount());
        ACosCommandTest.assertEquals(1, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        ACosCommandTest.assertEquals(0, this.acosCommand.getCurrentParameterCount());
        this.acosCommand.addParameter(mock1);
        this.acosCommand.addParameter(mock2);
        ACosCommandTest.assertEquals(1, this.acosCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.acosCommand.addParameter(nc1);
        ACosCommandTest.assertEquals(1097, this.acosCommand.doCommand());
        nc1.setNumber(0);
        ACosCommandTest.assertEquals(1, this.acosCommand.getCurrentParameterCount());
        ACosCommandTest.assertEquals(1570, this.acosCommand.doCommand());
        nc1.setNumber(-1570);
        ACosCommandTest.assertEquals(2177, this.acosCommand.doCommand());
    }

    public void testIsThisCommand() {
        ACosCommandTest.assertTrue(this.acosCommand.isThisCommand("ACOS") != null);
        ACosCommandTest.assertTrue(this.acosCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.acosCommand.addParameter(nc1);
        ACosCommandTest.assertEquals("ACOS 123456", this.acosCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ACosCommand");
        suite.addTestSuite(ACosCommandTest.class);
        return suite;
    }
}

