/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.ASinCommand;
import commands.IAICommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class ASinCommandTest
extends TestCase {
    private ASinCommand asinCommand = null;
    private AICommand aiCommand = null;

    public ASinCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.asinCommand = new ASinCommand();
        this.aiCommand = this.asinCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        ASinCommandTest.assertEquals("ASIN", this.asinCommand.getShortName());
        ASinCommandTest.assertEquals("ASIN", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        ASinCommandTest.assertEquals("Arcussinus", this.asinCommand.getLongName());
        ASinCommandTest.assertEquals("Arcussinus", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        ASinCommandTest.assertEquals(1, this.asinCommand.getParameterCount());
        ASinCommandTest.assertEquals(1, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        ASinCommandTest.assertEquals(0, this.asinCommand.getCurrentParameterCount());
        this.asinCommand.addParameter(mock1);
        this.asinCommand.addParameter(mock2);
        ASinCommandTest.assertEquals(1, this.asinCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.asinCommand.addParameter(nc1);
        ASinCommandTest.assertEquals(473, this.asinCommand.doCommand());
        nc1.setNumber(0);
        ASinCommandTest.assertEquals(1, this.asinCommand.getCurrentParameterCount());
        ASinCommandTest.assertEquals(0, this.asinCommand.doCommand());
        nc1.setNumber(-1570);
        ASinCommandTest.assertEquals(-606, this.asinCommand.doCommand());
    }

    public void testIsThisCommand() {
        ASinCommandTest.assertTrue(this.asinCommand.isThisCommand("ASIN") != null);
        ASinCommandTest.assertTrue(this.asinCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.asinCommand.addParameter(nc1);
        ASinCommandTest.assertEquals("ASIN 123456", this.asinCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ASinCommand");
        suite.addTestSuite(ASinCommandTest.class);
        return suite;
    }
}

