/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.ATanCommand;
import commands.IAICommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class ATanCommandTest
extends TestCase {
    private ATanCommand atanCommand = null;
    private AICommand aiCommand = null;

    public ATanCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.atanCommand = new ATanCommand();
        this.aiCommand = this.atanCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        ATanCommandTest.assertEquals("ATAN", this.atanCommand.getShortName());
        ATanCommandTest.assertEquals("ATAN", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        ATanCommandTest.assertEquals("Arcustangens", this.atanCommand.getLongName());
        ATanCommandTest.assertEquals("Arcustangens", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        ATanCommandTest.assertEquals(1, this.atanCommand.getParameterCount());
        ATanCommandTest.assertEquals(1, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        ATanCommandTest.assertEquals(0, this.atanCommand.getCurrentParameterCount());
        this.atanCommand.addParameter(mock1);
        this.atanCommand.addParameter(mock2);
        ATanCommandTest.assertEquals(1, this.atanCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.atanCommand.addParameter(nc1);
        ATanCommandTest.assertEquals(1562, this.atanCommand.doCommand());
        nc1.setNumber(0);
        ATanCommandTest.assertEquals(1, this.atanCommand.getCurrentParameterCount());
        ATanCommandTest.assertEquals(0, this.atanCommand.doCommand());
        nc1.setNumber(-1570);
        ATanCommandTest.assertEquals(-1003, this.atanCommand.doCommand());
    }

    public void testIsThisCommand() {
        ATanCommandTest.assertTrue(this.atanCommand.isThisCommand("ATAN") != null);
        ATanCommandTest.assertTrue(this.atanCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.atanCommand.addParameter(nc1);
        ATanCommandTest.assertEquals("ATAN 123456", this.atanCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ATanCommand");
        suite.addTestSuite(ATanCommandTest.class);
        return suite;
    }
}

