/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.AddCommand;
import commands.IAICommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class AddCommandTest
extends TestCase {
    private AddCommand addCommand = null;
    private AICommand aiCommand = null;

    public AddCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.addCommand = new AddCommand();
        this.aiCommand = this.addCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        AddCommandTest.assertEquals("ADD", this.addCommand.getShortName());
        AddCommandTest.assertEquals("ADD", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        AddCommandTest.assertEquals("+", this.addCommand.getLongName());
        AddCommandTest.assertEquals("+", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        AddCommandTest.assertEquals(2, this.addCommand.getParameterCount());
        AddCommandTest.assertEquals(2, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        AddCommandTest.assertEquals(0, this.addCommand.getCurrentParameterCount());
        this.addCommand.addParameter(mock1);
        this.addCommand.addParameter(mock2);
        AddCommandTest.assertEquals(2, this.addCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.addCommand.addParameter(nc1);
        try {
            AddCommandTest.assertEquals(123456, this.addCommand.doCommand());
        }
        catch (Exception e) {
            AddCommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.addCommand.addParameter(nc2);
        AddCommandTest.assertEquals(2, this.addCommand.getCurrentParameterCount());
        AddCommandTest.assertEquals(777777, this.addCommand.doCommand());
    }

    public void testIsThisCommand() {
        AddCommandTest.assertTrue(this.addCommand.isThisCommand("ADD") != null);
        AddCommandTest.assertTrue(this.addCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.addCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.addCommand.addParameter(nc2);
        AddCommandTest.assertEquals("ADD 123456 654321", this.addCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AddCommand");
        suite.addTestSuite(AddCommandTest.class);
        return suite;
    }
}

