/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.AndCommand;
import commands.IAICommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class AndCommandTest
extends TestCase {
    private AndCommand andCommand = null;
    private AICommand aiCommand = null;

    public AndCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.andCommand = new AndCommand();
        this.aiCommand = this.andCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        AndCommandTest.assertEquals("AND", this.andCommand.getShortName());
        AndCommandTest.assertEquals("AND", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        AndCommandTest.assertEquals("AND", this.andCommand.getLongName());
        AndCommandTest.assertEquals("AND", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        AndCommandTest.assertEquals(2, this.andCommand.getParameterCount());
        AndCommandTest.assertEquals(2, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        AndCommandTest.assertEquals(0, this.andCommand.getCurrentParameterCount());
        this.andCommand.addParameter(mock1);
        this.andCommand.addParameter(mock2);
        AndCommandTest.assertEquals(2, this.andCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.andCommand.addParameter(nc1);
        try {
            AndCommandTest.assertEquals(123456, this.andCommand.doCommand());
        }
        catch (Exception e) {
            AndCommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.andCommand.addParameter(nc2);
        AndCommandTest.assertEquals(2, this.andCommand.getCurrentParameterCount());
        AndCommandTest.assertEquals(654321, this.andCommand.doCommand());
        nc1.setNumber(-951753);
        AndCommandTest.assertEquals(-951753, this.andCommand.doCommand());
        nc1.setNumber(0);
        AndCommandTest.assertEquals(0, this.andCommand.doCommand());
        nc1.setNumber(-147258);
        AndCommandTest.assertEquals(-147258, this.andCommand.doCommand());
    }

    public void testIsThisCommand() {
        AndCommandTest.assertTrue(this.andCommand.isThisCommand("AND") != null);
        AndCommandTest.assertTrue(this.andCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.andCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.andCommand.addParameter(nc2);
        AndCommandTest.assertEquals("AND 123456 654321", this.andCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AndCommand");
        suite.addTestSuite(AndCommandTest.class);
        return suite;
    }
}

