/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.CosCommand;
import commands.IAICommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class CosCommandTest
extends TestCase {
    private CosCommand cosCommand = null;
    private AICommand aiCommand = null;

    public CosCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.cosCommand = new CosCommand();
        this.aiCommand = this.cosCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        CosCommandTest.assertEquals("COS", this.cosCommand.getShortName());
        CosCommandTest.assertEquals("COS", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        CosCommandTest.assertEquals("Cosinus", this.cosCommand.getLongName());
        CosCommandTest.assertEquals("Cosinus", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        CosCommandTest.assertEquals(1, this.cosCommand.getParameterCount());
        CosCommandTest.assertEquals(1, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        CosCommandTest.assertEquals(0, this.cosCommand.getCurrentParameterCount());
        this.cosCommand.addParameter(mock1);
        this.cosCommand.addParameter(mock2);
        CosCommandTest.assertEquals(1, this.cosCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.cosCommand.addParameter(nc1);
        CosCommandTest.assertEquals(-594, this.cosCommand.doCommand());
        nc1.setNumber(0);
        CosCommandTest.assertEquals(1, this.cosCommand.getCurrentParameterCount());
        CosCommandTest.assertEquals(1000, this.cosCommand.doCommand());
        nc1.setNumber(1570);
        CosCommandTest.assertEquals(0, this.cosCommand.doCommand());
    }

    public void testIsThisCommand() {
        CosCommandTest.assertTrue(this.cosCommand.isThisCommand("COS") != null);
        CosCommandTest.assertTrue(this.cosCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.cosCommand.addParameter(nc1);
        CosCommandTest.assertEquals("COS 123456", this.cosCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("CosCommand");
        suite.addTestSuite(CosCommandTest.class);
        return suite;
    }
}

