/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.DisplayCommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class DisplayCommandTest
extends TestCase {
    private DisplayCommand displayCommand = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.displayCommand = new DisplayCommand();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        DisplayCommandTest.assertEquals("DISP", this.displayCommand.getShortName());
    }

    public void testGetLongName() {
        DisplayCommandTest.assertEquals("ReadDisplay", this.displayCommand.getLongName());
    }

    public void testGetParameterCount() {
        DisplayCommandTest.assertEquals(1, this.displayCommand.getParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc = new NumberCommand();
        nc.setNumber(3000);
        this.displayCommand.addParameter(nc);
        DisplayCommandTest.assertEquals(0, this.displayCommand.doCommand());
    }

    public void testIsThisCommand() {
        DisplayCommandTest.assertTrue(this.displayCommand.isThisCommand("DISP") != null);
        DisplayCommandTest.assertTrue(this.displayCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.displayCommand.addParameter(nc1);
        DisplayCommandTest.assertEquals("DISP 123456", this.displayCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("DisplayCommand");
        suite.addTestSuite(DisplayCommandTest.class);
        return suite;
    }
}

