/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.DivCommand;
import commands.IAICommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class DivCommandTest
extends TestCase {
    private DivCommand divCommand = null;
    private AICommand aiCommand = null;

    public DivCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.divCommand = new DivCommand();
        this.aiCommand = this.divCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        DivCommandTest.assertEquals("DIV", this.divCommand.getShortName());
        DivCommandTest.assertEquals("DIV", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        DivCommandTest.assertEquals("/", this.divCommand.getLongName());
        DivCommandTest.assertEquals("/", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        DivCommandTest.assertEquals(2, this.divCommand.getParameterCount());
        DivCommandTest.assertEquals(2, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        DivCommandTest.assertEquals(0, this.divCommand.getCurrentParameterCount());
        this.divCommand.addParameter(mock1);
        this.divCommand.addParameter(mock2);
        DivCommandTest.assertEquals(2, this.divCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.divCommand.addParameter(nc1);
        try {
            DivCommandTest.assertEquals(123456, this.divCommand.doCommand());
        }
        catch (Exception e) {
            DivCommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.divCommand.addParameter(nc2);
        DivCommandTest.assertEquals(2, this.divCommand.getCurrentParameterCount());
        DivCommandTest.assertEquals(188, this.divCommand.doCommand());
        nc2.setNumber(0);
        DivCommandTest.assertEquals(0, this.divCommand.doCommand());
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.divCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.divCommand.addParameter(nc2);
        DivCommandTest.assertEquals("DIV 123456 654321", this.divCommand.getString());
    }

    public void testIsThisCommand() {
        DivCommandTest.assertTrue(this.divCommand.isThisCommand("DIV") != null);
        DivCommandTest.assertTrue(this.divCommand.isThisCommand("FALSCH") == null);
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("DivCommand");
        suite.addTestSuite(DivCommandTest.class);
        return suite;
    }
}

