/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.EquCommand;
import commands.IAICommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class EquCommandTest
extends TestCase {
    private EquCommand equCommand = null;
    private AICommand aiCommand = null;

    public EquCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.equCommand = new EquCommand();
        this.aiCommand = this.equCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        EquCommandTest.assertEquals("EQU", this.equCommand.getShortName());
        EquCommandTest.assertEquals("EQU", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        EquCommandTest.assertEquals("Equal", this.equCommand.getLongName());
        EquCommandTest.assertEquals("Equal", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        EquCommandTest.assertEquals(2, this.equCommand.getParameterCount());
        EquCommandTest.assertEquals(2, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        EquCommandTest.assertEquals(0, this.equCommand.getCurrentParameterCount());
        this.equCommand.addParameter(mock1);
        this.equCommand.addParameter(mock2);
        EquCommandTest.assertEquals(2, this.equCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.equCommand.addParameter(nc1);
        try {
            EquCommandTest.assertEquals(-1000, this.equCommand.doCommand());
        }
        catch (Exception e) {
            EquCommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.equCommand.addParameter(nc2);
        EquCommandTest.assertEquals(2, this.equCommand.getCurrentParameterCount());
        EquCommandTest.assertEquals(-1000, this.equCommand.doCommand());
        nc2.setNumber(123456);
        EquCommandTest.assertEquals(1000, this.equCommand.doCommand());
    }

    public void testIsThisCommand() {
        EquCommandTest.assertTrue(this.equCommand.isThisCommand("EQU") != null);
        EquCommandTest.assertTrue(this.equCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.equCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.equCommand.addParameter(nc2);
        EquCommandTest.assertEquals("EQU 123456 654321", this.equCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("EquCommand");
        suite.addTestSuite(EquCommandTest.class);
        return suite;
    }
}

