/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.ITECommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class ITECommandTest
extends TestCase {
    private ITECommand iteCommand = null;
    private AICommand aiCommand = null;

    public ITECommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.iteCommand = new ITECommand();
        this.aiCommand = this.iteCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        ITECommandTest.assertEquals("ITE", this.iteCommand.getShortName());
        ITECommandTest.assertEquals("ITE", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        ITECommandTest.assertEquals("IfThenElse", this.iteCommand.getLongName());
        ITECommandTest.assertEquals("IfThenElse", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        ITECommandTest.assertEquals(3, this.iteCommand.getParameterCount());
        ITECommandTest.assertEquals(3, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        ITECommandTest.assertEquals(0, this.iteCommand.getCurrentParameterCount());
        this.iteCommand.addParameter(mock1);
        this.iteCommand.addParameter(mock2);
        ITECommandTest.assertEquals(2, this.iteCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.iteCommand.addParameter(nc1);
        try {
            ITECommandTest.assertEquals(0, this.iteCommand.doCommand());
        }
        catch (Exception e) {
            ITECommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(-654321);
        this.iteCommand.addParameter(nc2);
        NumberCommand nc3 = new NumberCommand();
        nc3.setNumber(852351);
        this.iteCommand.addParameter(nc3);
        ITECommandTest.assertEquals(3, this.iteCommand.getCurrentParameterCount());
        ITECommandTest.assertEquals(-654321, this.iteCommand.doCommand());
        nc1.setNumber(-951753);
        ITECommandTest.assertEquals(852351, this.iteCommand.doCommand());
    }

    public void testIsThisCommand() {
        ITECommandTest.assertTrue(this.iteCommand.isThisCommand("ITE") != null);
        ITECommandTest.assertTrue(this.iteCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.iteCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.iteCommand.addParameter(nc2);
        NumberCommand nc3 = new NumberCommand();
        nc3.setNumber(15975378);
        this.iteCommand.addParameter(nc3);
        ITECommandTest.assertEquals("ITE 123456 654321 15975378", this.iteCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ITECommand");
        suite.addTestSuite(ITECommandTest.class);
        return suite;
    }
}

