/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.Key2Command;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class Key2CommandTest
extends TestCase {
    private Key2Command key2Command = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.key2Command = new Key2Command();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        Key2CommandTest.assertEquals("KEY", this.key2Command.getShortName());
    }

    public void testGetLongName() {
        Key2CommandTest.assertEquals("SendKey", this.key2Command.getLongName());
    }

    public void testGetParameterCount() {
        Key2CommandTest.assertEquals(1, this.key2Command.getParameterCount());
    }

    public void testIsThisCommand() {
        Key2Command tmp = (Key2Command)this.key2Command.isThisCommand("KEYP");
        Key2CommandTest.assertTrue(tmp == null);
        tmp = (Key2Command)this.key2Command.isThisCommand("KEYR");
        Key2CommandTest.assertTrue(tmp == null);
        tmp = (Key2Command)this.key2Command.isThisCommand("KEY");
        Key2CommandTest.assertTrue(tmp != null);
        Key2CommandTest.assertEquals("KEY", tmp.getShortName());
        Key2CommandTest.assertTrue(this.key2Command.isThisCommand("FALSCH") == null);
    }

    public void testDoCommand() {
        NumberCommand nc = new NumberCommand();
        nc.setNumber(3456);
        this.key2Command.addParameter(nc);
        Key2CommandTest.assertEquals(3456, this.key2Command.doCommand());
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.key2Command.addParameter(nc1);
        Key2CommandTest.assertEquals("KEY 123456", this.key2Command.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Key2Command");
        suite.addTestSuite(Key2CommandTest.class);
        return suite;
    }
}

