/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.KeyCommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class KeyCommandTest
extends TestCase {
    private KeyCommand keyCommand = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.keyCommand = new KeyCommand();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        this.keyCommand.setType(KeyCommand.Type.PRESS);
        KeyCommandTest.assertEquals("KEYP", this.keyCommand.getShortName());
        this.keyCommand.setType(KeyCommand.Type.RELEASE);
        KeyCommandTest.assertEquals("KEYR", this.keyCommand.getShortName());
    }

    public void testGetLongName() {
        this.keyCommand.setType(KeyCommand.Type.PRESS);
        KeyCommandTest.assertEquals("SendKeyPress", this.keyCommand.getLongName());
        this.keyCommand.setType(KeyCommand.Type.RELEASE);
        KeyCommandTest.assertEquals("SendKeyRelease", this.keyCommand.getLongName());
    }

    public void testGetParameterCount() {
        KeyCommandTest.assertEquals(1, this.keyCommand.getParameterCount());
    }

    public void testIsThisCommand() {
        KeyCommand tmp = (KeyCommand)this.keyCommand.isThisCommand("KEYP");
        KeyCommandTest.assertTrue(tmp != null);
        KeyCommandTest.assertEquals("KEYP", tmp.getShortName());
        tmp = (KeyCommand)this.keyCommand.isThisCommand("KEYR");
        KeyCommandTest.assertTrue(tmp != null);
        KeyCommandTest.assertEquals("KEYR", tmp.getShortName());
        KeyCommandTest.assertTrue(this.keyCommand.isThisCommand("FALSCH") == null);
    }

    public void testDoCommand() {
        NumberCommand nc = new NumberCommand();
        nc.setNumber(3456);
        this.keyCommand.addParameter(nc);
        KeyCommandTest.assertEquals(3456, this.keyCommand.doCommand());
    }

    public void testGetString() {
        this.keyCommand.setType(KeyCommand.Type.PRESS);
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.keyCommand.addParameter(nc1);
        KeyCommandTest.assertEquals("KEYP 123456", this.keyCommand.getString());
        this.keyCommand.setType(KeyCommand.Type.RELEASE);
        KeyCommandTest.assertEquals("KEYR 123456", this.keyCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("KeyCommand");
        suite.addTestSuite(KeyCommandTest.class);
        return suite;
    }
}

