/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.LetCommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class LetCommandTest
extends TestCase {
    private LetCommand letCommand = null;
    private AICommand aiCommand = null;

    public LetCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.letCommand = new LetCommand();
        this.aiCommand = this.letCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        LetCommandTest.assertEquals("LET", this.letCommand.getShortName());
        LetCommandTest.assertEquals("LET", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        LetCommandTest.assertEquals("LessThan", this.letCommand.getLongName());
        LetCommandTest.assertEquals("LessThan", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        LetCommandTest.assertEquals(2, this.letCommand.getParameterCount());
        LetCommandTest.assertEquals(2, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        LetCommandTest.assertEquals(0, this.letCommand.getCurrentParameterCount());
        this.letCommand.addParameter(mock1);
        this.letCommand.addParameter(mock2);
        LetCommandTest.assertEquals(2, this.letCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.letCommand.addParameter(nc1);
        try {
            LetCommandTest.assertEquals(-1000, this.letCommand.doCommand());
        }
        catch (Exception e) {
            LetCommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.letCommand.addParameter(nc2);
        LetCommandTest.assertEquals(2, this.letCommand.getCurrentParameterCount());
        LetCommandTest.assertEquals(1000, this.letCommand.doCommand());
        nc1.setNumber(654321);
        LetCommandTest.assertEquals(-1000, this.letCommand.doCommand());
    }

    public void testIsThisCommand() {
        LetCommandTest.assertTrue(this.letCommand.isThisCommand("LET") != null);
        LetCommandTest.assertTrue(this.letCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.letCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.letCommand.addParameter(nc2);
        LetCommandTest.assertEquals("LET 123456 654321", this.letCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("LetCommand");
        suite.addTestSuite(LetCommandTest.class);
        return suite;
    }
}

