/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.LogCommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class LogCommandTest
extends TestCase {
    private LogCommand logCommand = null;
    private AICommand aiCommand = null;

    public LogCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.logCommand = new LogCommand();
        this.aiCommand = this.logCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        LogCommandTest.assertEquals("LOG", this.logCommand.getShortName());
        LogCommandTest.assertEquals("LOG", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        LogCommandTest.assertEquals("Logarithm", this.logCommand.getLongName());
        LogCommandTest.assertEquals("Logarithm", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        LogCommandTest.assertEquals(1, this.logCommand.getParameterCount());
        LogCommandTest.assertEquals(1, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        LogCommandTest.assertEquals(0, this.logCommand.getCurrentParameterCount());
        this.logCommand.addParameter(mock1);
        LogCommandTest.assertEquals(1, this.logCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.logCommand.addParameter(nc1);
        LogCommandTest.assertEquals(1, this.logCommand.getCurrentParameterCount());
        LogCommandTest.assertEquals(4815, this.logCommand.doCommand());
        nc1.setNumber(0);
        LogCommandTest.assertEquals(0, this.logCommand.doCommand());
        nc1.setNumber(-654321);
        LogCommandTest.assertEquals(0, this.logCommand.doCommand());
    }

    public void testIsThisCommand() {
        LogCommandTest.assertTrue(this.logCommand.isThisCommand("LOG") != null);
        LogCommandTest.assertTrue(this.logCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.logCommand.addParameter(nc1);
        LogCommandTest.assertEquals("LOG 123456", this.logCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("LogCommand");
        suite.addTestSuite(LogCommandTest.class);
        return suite;
    }
}

