/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.MulCommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class MulCommandTest
extends TestCase {
    private MulCommand mulCommand = null;
    private AICommand aiCommand = null;

    public MulCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mulCommand = new MulCommand();
        this.aiCommand = this.mulCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        MulCommandTest.assertEquals("MUL", this.mulCommand.getShortName());
        MulCommandTest.assertEquals("MUL", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        MulCommandTest.assertEquals("*", this.mulCommand.getLongName());
        MulCommandTest.assertEquals("*", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        MulCommandTest.assertEquals(2, this.mulCommand.getParameterCount());
        MulCommandTest.assertEquals(2, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        MulCommandTest.assertEquals(0, this.mulCommand.getCurrentParameterCount());
        this.mulCommand.addParameter(mock1);
        this.mulCommand.addParameter(mock2);
        MulCommandTest.assertEquals(2, this.mulCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.mulCommand.addParameter(nc1);
        try {
            MulCommandTest.assertEquals(123456, this.mulCommand.doCommand());
        }
        catch (Exception e) {
            MulCommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(2000);
        this.mulCommand.addParameter(nc2);
        MulCommandTest.assertEquals(2, this.mulCommand.getCurrentParameterCount());
        MulCommandTest.assertEquals(246912, this.mulCommand.doCommand());
        nc2.setNumber(654321);
        MulCommandTest.assertEquals(80779853, this.mulCommand.doCommand());
    }

    public void testIsThisCommand() {
        MulCommandTest.assertTrue(this.mulCommand.isThisCommand("MUL") != null);
        MulCommandTest.assertTrue(this.mulCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.mulCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.mulCommand.addParameter(nc2);
        MulCommandTest.assertEquals("MUL 123456 654321", this.mulCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("MulCommand");
        suite.addTestSuite(MulCommandTest.class);
        return suite;
    }
}

