/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.NotCommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class NotCommandTest
extends TestCase {
    private NotCommand notCommand = null;
    private AICommand aiCommand = null;

    public NotCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.notCommand = new NotCommand();
        this.aiCommand = this.notCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        NotCommandTest.assertEquals("NOT", this.notCommand.getShortName());
        NotCommandTest.assertEquals("NOT", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        NotCommandTest.assertEquals("Not", this.notCommand.getLongName());
        NotCommandTest.assertEquals("Not", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        NotCommandTest.assertEquals(1, this.notCommand.getParameterCount());
        NotCommandTest.assertEquals(1, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        NotCommandTest.assertEquals(0, this.notCommand.getCurrentParameterCount());
        this.notCommand.addParameter(mock1);
        NotCommandTest.assertEquals(1, this.notCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.notCommand.addParameter(nc1);
        NotCommandTest.assertEquals(1, this.notCommand.getCurrentParameterCount());
        NotCommandTest.assertEquals(-123457, this.notCommand.doCommand());
        nc1.setNumber(-654321);
        NotCommandTest.assertEquals(654322, this.notCommand.doCommand());
    }

    public void testIsThisCommand() {
        NotCommandTest.assertTrue(this.notCommand.isThisCommand("NOT") != null);
        NotCommandTest.assertTrue(this.notCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.notCommand.addParameter(nc1);
        NotCommandTest.assertEquals("NOT 123456", this.notCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("NotCommand");
        suite.addTestSuite(NotCommandTest.class);
        return suite;
    }
}

