/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.NumberCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class NumberCommandTest
extends TestCase {
    private NumberCommand numberCommand = null;
    private AICommand aiCommand = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.numberCommand = new NumberCommand();
        this.aiCommand = this.numberCommand;
        this.numberCommand.setNumber(123456);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        NumberCommandTest.assertEquals("123456", this.numberCommand.getShortName());
        NumberCommandTest.assertEquals("123456", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        NumberCommandTest.assertEquals("123.456", this.numberCommand.getLongName());
        NumberCommandTest.assertEquals("123.456", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        NumberCommandTest.assertEquals(0, this.numberCommand.getParameterCount());
        NumberCommandTest.assertEquals(0, this.aiCommand.getParameterCount());
    }

    public void testDoCommand() {
        NumberCommandTest.assertEquals(123456, this.numberCommand.doCommand());
        NumberCommandTest.assertEquals(123456, this.aiCommand.doCommand());
    }

    public void testIsThisCommand() {
        NumberCommand nc2 = (NumberCommand)this.numberCommand.isThisCommand("123456");
        NumberCommandTest.assertTrue(nc2 != null);
        NumberCommandTest.assertEquals("123456", nc2.getShortName());
        NumberCommandTest.assertTrue(this.numberCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        this.numberCommand.setNumber(123456);
        NumberCommandTest.assertEquals("123456", this.numberCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("NumberCommand");
        suite.addTestSuite(NumberCommandTest.class);
        return suite;
    }
}

