/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.OrCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class OrCommandTest
extends TestCase {
    private OrCommand orCommand = null;
    private AICommand aiCommand = null;

    public OrCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.orCommand = new OrCommand();
        this.aiCommand = this.orCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        OrCommandTest.assertEquals("OR", this.orCommand.getShortName());
        OrCommandTest.assertEquals("OR", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        OrCommandTest.assertEquals("OR", this.orCommand.getLongName());
        OrCommandTest.assertEquals("OR", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        OrCommandTest.assertEquals(2, this.orCommand.getParameterCount());
        OrCommandTest.assertEquals(2, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        OrCommandTest.assertEquals(0, this.orCommand.getCurrentParameterCount());
        this.orCommand.addParameter(mock1);
        this.orCommand.addParameter(mock2);
        OrCommandTest.assertEquals(2, this.orCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.orCommand.addParameter(nc1);
        try {
            OrCommandTest.assertEquals(123456, this.orCommand.doCommand());
        }
        catch (Exception e) {
            OrCommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.orCommand.addParameter(nc2);
        OrCommandTest.assertEquals(2, this.orCommand.getCurrentParameterCount());
        OrCommandTest.assertEquals(123456, this.orCommand.doCommand());
        nc2.setNumber(-951753);
        OrCommandTest.assertEquals(123456, this.orCommand.doCommand());
        nc1.setNumber(0);
        OrCommandTest.assertEquals(-951753, this.orCommand.doCommand());
        nc1.setNumber(-147258);
        OrCommandTest.assertEquals(-951753, this.orCommand.doCommand());
        nc2.setNumber(654321);
        OrCommandTest.assertEquals(654321, this.orCommand.doCommand());
    }

    public void testIsThisCommand() {
        OrCommandTest.assertTrue(this.orCommand.isThisCommand("OR") != null);
        OrCommandTest.assertTrue(this.orCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.orCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.orCommand.addParameter(nc2);
        OrCommandTest.assertEquals("OR 123456 654321", this.orCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("OrCommand");
        suite.addTestSuite(OrCommandTest.class);
        return suite;
    }
}

