/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.NumberCommand;
import commands.ReadCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import simulation.Memory;

public class ReadCommandTest
extends TestCase {
    private ReadCommand readCommand = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.readCommand = new ReadCommand();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        ReadCommandTest.assertEquals("READ", this.readCommand.getShortName());
    }

    public void testGetLongName() {
        ReadCommandTest.assertEquals("ReadMemory", this.readCommand.getLongName());
    }

    public void testGetParameterCount() {
        ReadCommandTest.assertEquals(1, this.readCommand.getParameterCount());
    }

    public void testDoCommand() {
        Memory memory = new Memory();
        int size = 10;
        memory.setSize(size);
        int i = 0;
        while (i < size) {
            memory.setValue(i, size - i);
            ++i;
        }
        this.readCommand.setMemory(memory);
        NumberCommand nc = new NumberCommand();
        nc.setNumber(3000);
        this.readCommand.addParameter(nc);
        ReadCommandTest.assertEquals(7, this.readCommand.doCommand());
        nc.setNumber(14000);
        ReadCommandTest.assertEquals(6, this.readCommand.doCommand());
    }

    public void testIsThisCommand() {
        ReadCommandTest.assertTrue(this.readCommand.isThisCommand("READ") != null);
        ReadCommandTest.assertTrue(this.readCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.readCommand.addParameter(nc1);
        ReadCommandTest.assertEquals("READ 123456", this.readCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ReadCommand");
        suite.addTestSuite(ReadCommandTest.class);
        return suite;
    }
}

