/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.SinCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class SinCommandTest
extends TestCase {
    private SinCommand sinCommand = null;
    private AICommand aiCommand = null;

    public SinCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sinCommand = new SinCommand();
        this.aiCommand = this.sinCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        SinCommandTest.assertEquals("SIN", this.sinCommand.getShortName());
        SinCommandTest.assertEquals("SIN", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        SinCommandTest.assertEquals("Sinus", this.sinCommand.getLongName());
        SinCommandTest.assertEquals("Sinus", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        SinCommandTest.assertEquals(1, this.sinCommand.getParameterCount());
        SinCommandTest.assertEquals(1, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        SinCommandTest.assertEquals(0, this.sinCommand.getCurrentParameterCount());
        this.sinCommand.addParameter(mock1);
        this.sinCommand.addParameter(mock2);
        SinCommandTest.assertEquals(1, this.sinCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.sinCommand.addParameter(nc1);
        SinCommandTest.assertEquals(-803, this.sinCommand.doCommand());
        nc1.setNumber(0);
        SinCommandTest.assertEquals(1, this.sinCommand.getCurrentParameterCount());
        SinCommandTest.assertEquals(0, this.sinCommand.doCommand());
        nc1.setNumber(1570);
        SinCommandTest.assertEquals(999, this.sinCommand.doCommand());
    }

    public void testIsThisCommand() {
        SinCommandTest.assertTrue(this.sinCommand.isThisCommand("SIN") != null);
        SinCommandTest.assertTrue(this.sinCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.sinCommand.addParameter(nc1);
        SinCommandTest.assertEquals("SIN 123456", this.sinCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SinCommand");
        suite.addTestSuite(SinCommandTest.class);
        return suite;
    }
}

