/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.NumberCommand;
import commands.SleepCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SleepCommandTest
extends TestCase {
    private SleepCommand sleepCommand = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sleepCommand = new SleepCommand();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        SleepCommandTest.assertEquals("SLEEP", this.sleepCommand.getShortName());
    }

    public void testGetLongName() {
        SleepCommandTest.assertEquals("Sleep", this.sleepCommand.getLongName());
    }

    public void testGetParameterCount() {
        SleepCommandTest.assertEquals(2, this.sleepCommand.getParameterCount());
    }

    public void testIsThisCommand() {
        SleepCommandTest.assertTrue(this.sleepCommand.isThisCommand("SLEEP") != null);
        SleepCommandTest.assertTrue(this.sleepCommand.isThisCommand("FALSCH") == null);
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.sleepCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.sleepCommand.addParameter(nc2);
        SleepCommandTest.assertEquals(2, this.sleepCommand.getCurrentParameterCount());
        SleepCommandTest.assertEquals(654321, this.sleepCommand.doCommand(false));
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.sleepCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.sleepCommand.addParameter(nc2);
        SleepCommandTest.assertEquals("SLEEP 123456 654321", this.sleepCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SleepCommand");
        suite.addTestSuite(SleepCommandTest.class);
        return suite;
    }
}

