/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.SqrCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class SqrCommandTest
extends TestCase {
    private SqrCommand sqrCommand = null;
    private AICommand aiCommand = null;

    public SqrCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sqrCommand = new SqrCommand();
        this.aiCommand = this.sqrCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        SqrCommandTest.assertEquals("SQR", this.sqrCommand.getShortName());
        SqrCommandTest.assertEquals("SQR", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        SqrCommandTest.assertEquals("SquareRoot", this.sqrCommand.getLongName());
        SqrCommandTest.assertEquals("SquareRoot", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        SqrCommandTest.assertEquals(1, this.sqrCommand.getParameterCount());
        SqrCommandTest.assertEquals(1, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        SqrCommandTest.assertEquals(0, this.sqrCommand.getCurrentParameterCount());
        this.sqrCommand.addParameter(mock1);
        SqrCommandTest.assertEquals(1, this.sqrCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.sqrCommand.addParameter(nc1);
        SqrCommandTest.assertEquals(1, this.sqrCommand.getCurrentParameterCount());
        SqrCommandTest.assertEquals(11111, this.sqrCommand.doCommand());
        nc1.setNumber(0);
        SqrCommandTest.assertEquals(0, this.sqrCommand.doCommand());
        nc1.setNumber(-654321);
        SqrCommandTest.assertEquals(0, this.sqrCommand.doCommand());
    }

    public void testIsThisCommand() {
        SqrCommandTest.assertTrue(this.sqrCommand.isThisCommand("SQR") != null);
        SqrCommandTest.assertTrue(this.sqrCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.sqrCommand.addParameter(nc1);
        SqrCommandTest.assertEquals("SQR 123456", this.sqrCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SqrCommand");
        suite.addTestSuite(SqrCommandTest.class);
        return suite;
    }
}

