/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.SubCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class SubCommandTest
extends TestCase {
    private SubCommand subCommand = null;
    private AICommand aiCommand = null;

    public SubCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.subCommand = new SubCommand();
        this.aiCommand = this.subCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        SubCommandTest.assertEquals("SUB", this.subCommand.getShortName());
        SubCommandTest.assertEquals("SUB", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        SubCommandTest.assertEquals("-", this.subCommand.getLongName());
        SubCommandTest.assertEquals("-", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        SubCommandTest.assertEquals(2, this.subCommand.getParameterCount());
        SubCommandTest.assertEquals(2, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        SubCommandTest.assertEquals(0, this.subCommand.getCurrentParameterCount());
        this.subCommand.addParameter(mock1);
        this.subCommand.addParameter(mock2);
        SubCommandTest.assertEquals(2, this.subCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.subCommand.addParameter(nc1);
        try {
            SubCommandTest.assertEquals(123456, this.subCommand.doCommand());
        }
        catch (Exception e) {
            SubCommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.subCommand.addParameter(nc2);
        SubCommandTest.assertEquals(2, this.subCommand.getCurrentParameterCount());
        SubCommandTest.assertEquals(-530865, this.subCommand.doCommand());
    }

    public void testIsThisCommand() {
        SubCommandTest.assertTrue(this.subCommand.isThisCommand("SUB") != null);
        SubCommandTest.assertTrue(this.subCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.subCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.subCommand.addParameter(nc2);
        SubCommandTest.assertEquals("SUB 123456 654321", this.subCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SubCommand");
        suite.addTestSuite(SubCommandTest.class);
        return suite;
    }
}

