/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.SumCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class SumCommandTest
extends TestCase {
    private SumCommand sumCommand = null;
    private AICommand aiCommand = null;

    public SumCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sumCommand = new SumCommand();
        this.aiCommand = this.sumCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        SumCommandTest.assertEquals("SUM", this.sumCommand.getShortName());
        SumCommandTest.assertEquals("SUM", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        SumCommandTest.assertEquals("Sum", this.sumCommand.getLongName());
        SumCommandTest.assertEquals("Sum", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        SumCommandTest.assertEquals(2, this.sumCommand.getParameterCount());
        SumCommandTest.assertEquals(2, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        SumCommandTest.assertEquals(0, this.sumCommand.getCurrentParameterCount());
        this.sumCommand.addParameter(mock1);
        this.sumCommand.addParameter(mock2);
        SumCommandTest.assertEquals(2, this.sumCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(12345);
        this.sumCommand.addParameter(nc1);
        try {
            SumCommandTest.assertEquals(0, this.sumCommand.doCommand());
        }
        catch (Exception e) {
            SumCommandTest.fail("Missing Parameter should not result in a Exception: " + e.getMessage());
        }
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.sumCommand.addParameter(nc2);
        SumCommandTest.assertEquals(2, this.sumCommand.getCurrentParameterCount());
        SumCommandTest.assertEquals(7851852, this.sumCommand.doCommand());
    }

    public void testIsThisCommand() {
        SumCommandTest.assertTrue(this.sumCommand.isThisCommand("SUM") != null);
        SumCommandTest.assertTrue(this.sumCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.sumCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.sumCommand.addParameter(nc2);
        SumCommandTest.assertEquals("SUM 123456 654321", this.sumCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SumCommand");
        suite.addTestSuite(SumCommandTest.class);
        return suite;
    }
}

