/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.AICommand;
import commands.IAICommand;
import commands.NumberCommand;
import commands.TanCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;

public class TanCommandTest
extends TestCase {
    private TanCommand tanCommand = null;
    private AICommand aiCommand = null;

    public TanCommandTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.tanCommand = new TanCommand();
        this.aiCommand = this.tanCommand;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        TanCommandTest.assertEquals("TAN", this.tanCommand.getShortName());
        TanCommandTest.assertEquals("TAN", this.aiCommand.getShortName());
    }

    public void testGetLongName() {
        TanCommandTest.assertEquals("Tangens", this.tanCommand.getLongName());
        TanCommandTest.assertEquals("Tangens", this.aiCommand.getLongName());
    }

    public void testGetParameterCount() {
        TanCommandTest.assertEquals(1, this.tanCommand.getParameterCount());
        TanCommandTest.assertEquals(1, this.aiCommand.getParameterCount());
    }

    public void testAddParameter() {
        IAICommand mock1 = EasyMock.createStrictMock(IAICommand.class);
        IAICommand mock2 = EasyMock.createStrictMock(IAICommand.class);
        EasyMock.replay(new Object[0]);
        TanCommandTest.assertEquals(0, this.tanCommand.getCurrentParameterCount());
        this.tanCommand.addParameter(mock1);
        this.tanCommand.addParameter(mock2);
        TanCommandTest.assertEquals(1, this.tanCommand.getCurrentParameterCount());
    }

    public void testDoCommand() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.tanCommand.addParameter(nc1);
        TanCommandTest.assertEquals(1351, this.tanCommand.doCommand());
        nc1.setNumber(0);
        TanCommandTest.assertEquals(1, this.tanCommand.getCurrentParameterCount());
        TanCommandTest.assertEquals(0, this.tanCommand.doCommand());
        nc1.setNumber(-1570);
        TanCommandTest.assertEquals(-1255765, this.tanCommand.doCommand());
    }

    public void testIsThisCommand() {
        TanCommandTest.assertTrue(this.tanCommand.isThisCommand("TAN") != null);
        TanCommandTest.assertTrue(this.tanCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.tanCommand.addParameter(nc1);
        TanCommandTest.assertEquals("TAN 123456", this.tanCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TanCommand");
        suite.addTestSuite(TanCommandTest.class);
        return suite;
    }
}

