/*
 * Decompiled with CFR 0.152.
 */
package commandTests;

import commands.NumberCommand;
import commands.WriteCommand;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import simulation.Memory;

public class WriteCommandTest
extends TestCase {
    private WriteCommand writeCommand = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.writeCommand = new WriteCommand();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetShortName() {
        WriteCommandTest.assertEquals("WRITE", this.writeCommand.getShortName());
    }

    public void testGetLongName() {
        WriteCommandTest.assertEquals("WriteMemory", this.writeCommand.getLongName());
    }

    public void testGetParameterCount() {
        WriteCommandTest.assertEquals(2, this.writeCommand.getParameterCount());
    }

    public void testDoCommand() {
        Memory memory = new Memory();
        int size = 10;
        int value1 = 3;
        int value2 = 6000;
        memory.setSize(size);
        this.writeCommand.setMemory(memory);
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(value1 * 1000);
        this.writeCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(value2);
        this.writeCommand.addParameter(nc2);
        WriteCommandTest.assertEquals(value2, this.writeCommand.doCommand());
        WriteCommandTest.assertEquals(value2, memory.getValue(value1));
    }

    public void testIsThisCommand() {
        WriteCommandTest.assertTrue(this.writeCommand.isThisCommand("WRITE") != null);
        WriteCommandTest.assertTrue(this.writeCommand.isThisCommand("FALSCH") == null);
    }

    public void testGetString() {
        NumberCommand nc1 = new NumberCommand();
        nc1.setNumber(123456);
        this.writeCommand.addParameter(nc1);
        NumberCommand nc2 = new NumberCommand();
        nc2.setNumber(654321);
        this.writeCommand.addParameter(nc2);
        WriteCommandTest.assertEquals("WRITE 123456 654321", this.writeCommand.getString());
    }

    public static final Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("WriteCommand");
        suite.addTestSuite(WriteCommandTest.class);
        return suite;
    }
}

