/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.IAICommand;
import global.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class AICommand
implements IAICommand {
    private List<IAICommand> parameters = new ArrayList<IAICommand>();
    private Logger logger = null;
    protected boolean stop = false;

    public abstract String getShortName();

    public abstract String getLongName();

    public abstract int getParameterCount();

    @Override
    public abstract IAICommand isThisCommand(String var1);

    @Override
    public abstract int doCommand();

    @Override
    public abstract int doCommand(boolean var1);

    public abstract boolean isConstant();

    public abstract boolean hasSideEffects(boolean var1);

    public abstract IsExecutedType isParameterExecuted(int var1);

    public abstract IAICommand copy();

    public abstract IAICommand copyRandom();

    public AICommand() {
    }

    public AICommand(AICommand src) {
        this.setLogger(src.getLogger());
        int i = 0;
        while (i < src.getCurrentParameterCount()) {
            IAICommand param = ((AICommand)src.getParameter(i)).copy();
            this.addParameter(param);
            ++i;
        }
    }

    public void addParameter(IAICommand cmd) {
        if (this.parameters != null && this.parameters.size() < this.getParameterCount()) {
            this.parameters.add(cmd);
        }
    }

    public int getCurrentParameterCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public IAICommand getParameter(int i) {
        if (i >= 0 && i < this.getCurrentParameterCount()) {
            return this.parameters.get(i);
        }
        return null;
    }

    public void setParameter(int i, AICommand command) {
        if (i >= 0 && i < this.getCurrentParameterCount()) {
            this.parameters.set(i, command);
        }
    }

    public int getProgramDepth() {
        int ret = 0;
        int i = 0;
        while (i < this.getCurrentParameterCount()) {
            int tmp = ((AICommand)this.getParameter(i)).getProgramDepth();
            if (tmp > ret) {
                ret = tmp;
            }
            ++i;
        }
        return ret + 1;
    }

    public void clearParameter() {
        this.parameters.clear();
    }

    public void setLogger(Logger newLogger) {
        this.logger = newLogger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void logError(String method, String text) {
        if (this.logger != null) {
            this.logger.LogError(method, text);
        }
    }

    public void logExecute(String method, String text) {
        if (this.logger != null) {
            this.logger.LogExecute(method, text);
        }
    }

    public String getString() {
        String ret = this.getShortName();
        int i = 0;
        while (i < this.getCurrentParameterCount()) {
            ret = String.valueOf(ret) + " " + ((AICommand)this.getParameter(i)).getString();
            ++i;
        }
        return ret;
    }

    public void setRandomValue(Random random) {
    }

    public void stopExec() {
        this.stop = true;
        int i = this.getCurrentParameterCount() - 1;
        while (i >= 0) {
            ((AICommand)this.getParameter(i)).stopExec();
            --i;
        }
    }

    public void resetStopExec() {
        this.stop = false;
        int i = 0;
        while (i < this.getCurrentParameterCount()) {
            ((AICommand)this.getParameter(i)).resetStopExec();
            ++i;
        }
    }

    public boolean isTrue(int value) {
        return value > 0;
    }

    public static enum IsExecutedType {
        NEVER,
        MAYBE,
        ALWAYS;

    }
}

