/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;
import simulation.SimulationDisplay;

public class DisplayCommand
extends AICommand
implements IAICommand {
    private SimulationDisplay display = null;

    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        if (this.stop) {
            return 0;
        }
        int ret = 0;
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", String.valueOf(this.getLongName()) + "(");
        if (this.getParameter(0) != null) {
            int pos = this.getParameter(0).doCommand(withSideEffects) / 1000;
            if (!this.stop) {
                if (this.display != null) {
                    ret = this.display.getValue(Math.abs(pos));
                } else {
                    this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "Display not found");
                }
            }
        }
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ")" + this.getLongName() + " = " + ret);
        return ret;
    }

    @Override
    public String getLongName() {
        return "ReadDisplay";
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public String getShortName() {
        return "DISP";
    }

    @Override
    public IAICommand isThisCommand(String string) {
        if (string.equals(this.getShortName())) {
            return new DisplayCommand(this);
        }
        return null;
    }

    public void setDisplay(SimulationDisplay newDisplay) {
        this.display = newDisplay;
    }

    public SimulationDisplay getDisplay() {
        return this.display;
    }

    public DisplayCommand() {
    }

    public DisplayCommand(DisplayCommand src) {
        super(src);
        this.setDisplay(src.getDisplay());
    }

    @Override
    public IAICommand copy() {
        return new DisplayCommand(this);
    }

    @Override
    public IAICommand copyRandom() {
        return this.copy();
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        return AICommand.IsExecutedType.ALWAYS;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        return true;
    }
}

