/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;
import commands.KeyCommand;
import simulation.ICommunicationToSimulation;

public class Key2Command
extends AICommand
implements IAICommand {
    private ICommunicationToSimulation communication = null;

    public void setCommunication(ICommunicationToSimulation newCommunication) {
        this.communication = newCommunication;
    }

    public ICommunicationToSimulation getCommunication() {
        return this.communication;
    }

    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        if (this.stop) {
            return 0;
        }
        int ret = 0;
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", String.valueOf(this.getLongName()) + "(");
        if (this.getParameter(0) != null) {
            ret = this.getParameter(0).doCommand(withSideEffects);
            if (withSideEffects && !this.stop) {
                if (this.communication != null) {
                    this.communication.sendGameKeys(ret / 1000, KeyCommand.Type.PRESS);
                    this.communication.sendGameKeys(ret / 1000, KeyCommand.Type.RELEASE);
                } else {
                    this.logError(String.valueOf(this.getClass().getName()) + ".doCommand()", "No communication found");
                }
            }
        }
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ")" + this.getLongName() + " = " + ret);
        return ret;
    }

    @Override
    public String getLongName() {
        return "SendKey";
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public String getShortName() {
        return "KEY";
    }

    @Override
    public IAICommand isThisCommand(String string) {
        if (string.equals(this.getShortName())) {
            return new Key2Command(this);
        }
        return null;
    }

    public Key2Command() {
    }

    public Key2Command(Key2Command src) {
        super(src);
        this.setCommunication(src.getCommunication());
    }

    @Override
    public IAICommand copy() {
        return new Key2Command(this);
    }

    @Override
    public IAICommand copyRandom() {
        return this.copy();
    }

    @Override
    public boolean isConstant() {
        boolean ret = true;
        int i = 0;
        while (i < this.getCurrentParameterCount()) {
            ret = ret && ((AICommand)this.getParameter(i)).isConstant();
            ++i;
        }
        return ret;
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        return AICommand.IsExecutedType.ALWAYS;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        return true;
    }
}

