/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;
import simulation.ICommunicationToSimulation;

public class KeyCommand
extends AICommand
implements IAICommand {
    private ICommunicationToSimulation communication = null;
    private Type type = Type.PRESS;

    public void setCommunication(ICommunicationToSimulation newCommunication) {
        this.communication = newCommunication;
    }

    public ICommunicationToSimulation getCommunication() {
        return this.communication;
    }

    public Type setType(Type newType) {
        this.type = newType;
        return this.type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        if (this.stop) {
            return 0;
        }
        int ret = 0;
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand(" + (this.type == Type.PRESS ? "PRESS" : "RELEASE") + ")", String.valueOf(this.getLongName()) + "(");
        if (this.getParameter(0) != null) {
            ret = this.getParameter(0).doCommand(withSideEffects);
            if (withSideEffects && !this.stop) {
                if (this.communication != null) {
                    this.communication.sendGameKeys(ret / 1000, this.type);
                } else {
                    this.logError(String.valueOf(this.getClass().getName()) + ".doCommand(" + (this.type == Type.PRESS ? "PRESS" : "RELEASE") + ")", "No communication found");
                }
            }
        }
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand(" + (this.type == Type.PRESS ? "PRESS" : "RELEASE") + ")", ")" + this.getLongName() + " = " + ret);
        return ret;
    }

    @Override
    public String getLongName() {
        return "SendKey" + (this.type == Type.PRESS ? "Press" : "Release");
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public String getShortName() {
        return "KEY" + (this.type == Type.PRESS ? "P" : "R");
    }

    @Override
    public IAICommand isThisCommand(String string) {
        if (string.equals("KEYP") || string.equals("KEYR")) {
            KeyCommand ret = new KeyCommand(this);
            if (string.equals("KEYP")) {
                ret.setType(Type.PRESS);
            } else {
                ret.setType(Type.RELEASE);
            }
            return ret;
        }
        return null;
    }

    public KeyCommand() {
    }

    public KeyCommand(KeyCommand src) {
        super(src);
        this.setCommunication(src.getCommunication());
        this.setType(src.getType());
    }

    @Override
    public IAICommand copy() {
        return new KeyCommand(this);
    }

    @Override
    public IAICommand copyRandom() {
        return this.copy();
    }

    @Override
    public boolean isConstant() {
        boolean ret = true;
        int i = 0;
        while (i < this.getCurrentParameterCount()) {
            ret = ret && ((AICommand)this.getParameter(i)).isConstant();
            ++i;
        }
        return ret;
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        return AICommand.IsExecutedType.ALWAYS;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        return true;
    }

    public static enum Type {
        PRESS,
        RELEASE;

    }
}

