/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AICommand;
import commands.IAICommand;
import java.util.Random;

public class NumberCommand
extends AICommand {
    private int Float = 0;

    @Override
    public String getShortName() {
        return String.format("%6d", this.Float).trim();
    }

    @Override
    public String getLongName() {
        return String.format("%3d.%03d", this.Float / 1000, this.Float % 1000).trim();
    }

    @Override
    public int getParameterCount() {
        return 0;
    }

    @Override
    public int doCommand() {
        return this.doCommand(true);
    }

    @Override
    public int doCommand(boolean withSideEffects) {
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", String.valueOf(this.getLongName()) + "(");
        this.logExecute(String.valueOf(this.getClass().getName()) + ".doCommand()", ")" + this.getLongName() + " = " + this.Float);
        return this.Float;
    }

    @Override
    public IAICommand isThisCommand(String string) {
        try {
            int value = Integer.valueOf(string);
            NumberCommand ret = new NumberCommand(this);
            ret.setNumber(value);
            return ret;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public NumberCommand() {
        this.Float = (int)(Math.random() * 200000.0) - 100000;
    }

    public NumberCommand(NumberCommand src) {
        super(src);
        this.Float = src.Float;
    }

    @Override
    public void setRandomValue(Random random) {
        this.Float = (int)(random.nextDouble() * 200000.0) - 100000;
    }

    public void setNumber(int number) {
        this.Float = number;
    }

    public int getNumber() {
        return this.Float;
    }

    @Override
    public IAICommand copy() {
        return new NumberCommand(this);
    }

    @Override
    public IAICommand copyRandom() {
        NumberCommand ret = new NumberCommand();
        ret.setLogger(this.getLogger());
        return ret;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public AICommand.IsExecutedType isParameterExecuted(int paramID) {
        return AICommand.IsExecutedType.NEVER;
    }

    @Override
    public boolean hasSideEffects(boolean inclusiveParameter) {
        return false;
    }
}

